/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.genotype.geli;

import edu.mit.broad.picard.genotype.DiploidGenotype;
import java.util.Arrays;
import net.sf.picard.PicardException;
import net.sf.picard.util.Locus;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.util.StringUtil;

public class GenotypeLikelihoods
implements Locus {
    public static final float VERY_LIKELY = 0.99999f;
    public static final float VERY_UNLIKELY = 1.11262E-6f;
    public static final float LOG_VERY_LIKELY = (float)Math.log10(0.99999f);
    public static final float LOG_VERY_UNLIKELY = (float)Math.log10(1.11262E-6f);
    public static final int OBJECT_SIZE_BYTES = 150;
    private int sequenceIndex;
    private int position;
    private byte referenceBase;
    private int numReads;
    private short maxMappingQuality;
    private final float[] likelihoods = new float[10];
    private byte bestLikelihoodIndex = (byte)-1;
    private byte secondBestLikelihoodIndex = (byte)-1;
    private final SAMFileHeader fileHeader;
    private boolean firstAndSecondCalculated = false;
    private static final float INVALID_LIKELIHOOD = 1.0f;

    public GenotypeLikelihoods(SAMFileHeader fileHeader) {
        Arrays.fill(this.likelihoods, 1.0f);
        this.fileHeader = fileHeader;
    }

    public GenotypeLikelihoods(SAMFileHeader fileHeader, int sequenceIndex, int position, byte referenceBase, float[] likelihoods) {
        this.sequenceIndex = sequenceIndex;
        this.position = position;
        this.fileHeader = fileHeader;
        this.referenceBase = referenceBase;
        this.setLikelihoods(likelihoods);
    }

    public float getLikelihood(DiploidGenotype genotype) {
        if (this.likelihoods[genotype.ordinal()] > 0.0f) {
            throw new PicardException("Likelihood for " + genotype.name() + " not set!");
        }
        return this.likelihoods[genotype.ordinal()];
    }

    public void setLikelihood(DiploidGenotype genotype, float value) {
        int genotypeIndex = genotype.ordinal();
        this.likelihoods[genotypeIndex] = value;
        this.firstAndSecondCalculated = false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ref index ").append(this.sequenceIndex).append(":").append(this.position);
        builder.append(", ref base ").append((char)this.referenceBase);
        builder.append(", #reads ").append(this.numReads);
        builder.append(", quality ").append(this.maxMappingQuality);
        builder.append(" [");
        for (int i = 0; i < this.likelihoods.length; ++i) {
            builder.append((Object)DiploidGenotype.values()[i]).append(":").append(this.likelihoods[i]).append(" ");
        }
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int result = this.sequenceIndex;
        result = 31 * result + this.position;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenotypeLikelihoods other = (GenotypeLikelihoods)obj;
        if (this.sequenceIndex != other.sequenceIndex) {
            return false;
        }
        if (this.position != other.position) {
            return false;
        }
        if (this.referenceBase != other.referenceBase) {
            return false;
        }
        if (this.maxMappingQuality != other.maxMappingQuality) {
            return false;
        }
        if (this.numReads != other.numReads) {
            return false;
        }
        return Arrays.equals(this.likelihoods, other.likelihoods);
    }

    public boolean isHomozygousReference() {
        DiploidGenotype bestGenotype = this.getBestGenotype();
        return bestGenotype.isHomomozygous() && bestGenotype.getAllele1() == this.referenceBase;
    }

    public boolean isHomozyous() {
        return this.getBestGenotype().isHomomozygous();
    }

    public boolean isSameLocation(GenotypeLikelihoods that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        return this.sequenceIndex == that.sequenceIndex && this.position == that.position;
    }

    public float getBestLikelihood() {
        return this.likelihoods[this.getBestLikelihoodIndex()];
    }

    public float getSecondBestLikelihood() {
        return this.likelihoods[this.getSecondBestLikelihoodIndex()];
    }

    public DiploidGenotype getBestGenotype() {
        return DiploidGenotype.values()[this.getBestLikelihoodIndex()];
    }

    public DiploidGenotype getSecondBestGenotype() {
        return DiploidGenotype.values()[this.getSecondBestLikelihoodIndex()];
    }

    public float getBestToSecondBestLod() {
        return this.getBestLikelihood() - this.getSecondBestLikelihood();
    }

    public float getBestToReferenceLod() {
        if (!this.hasValidReferenceGenotype()) {
            return 0.0f;
        }
        return this.getBestLikelihood() - this.getReferenceGenotypeLikelihood();
    }

    public boolean hasValidReferenceGenotype() {
        return DiploidGenotype.isValidBase(this.referenceBase);
    }

    public String getSequenceName() {
        return this.fileHeader.getSequence(this.sequenceIndex).getSequenceName();
    }

    public void setLikelihoods(float[] likelihoods) {
        System.arraycopy(likelihoods, 0, this.likelihoods, 0, this.likelihoods.length);
        this.firstAndSecondCalculated = false;
    }

    private float getReferenceGenotypeLikelihood() {
        DiploidGenotype refGenotype = DiploidGenotype.fromBases(this.referenceBase, this.referenceBase);
        if (this.likelihoods[refGenotype.ordinal()] > 0.0f) {
            throw new PicardException("Reference genotype likelihood not set!");
        }
        return this.likelihoods[refGenotype.ordinal()];
    }

    private byte getBestLikelihoodIndex() {
        if (!this.firstAndSecondCalculated) {
            this.calculateFirstAndSecond();
        }
        if (this.bestLikelihoodIndex == -1) {
            throw new PicardException("Likelihoods not set!");
        }
        return this.bestLikelihoodIndex;
    }

    private byte getSecondBestLikelihoodIndex() {
        if (!this.firstAndSecondCalculated) {
            this.calculateFirstAndSecond();
        }
        if (this.secondBestLikelihoodIndex == -1) {
            throw new PicardException("Likelihoods not set!");
        }
        return this.secondBestLikelihoodIndex;
    }

    private void calculateFirstAndSecond() {
        this.bestLikelihoodIndex = (byte)-1;
        this.secondBestLikelihoodIndex = (byte)-1;
        for (int i = 0; i < this.likelihoods.length; ++i) {
            if (!(this.likelihoods[i] <= 0.0f)) continue;
            if (this.bestLikelihoodIndex == -1 || this.likelihoods[i] > this.likelihoods[this.bestLikelihoodIndex]) {
                this.secondBestLikelihoodIndex = this.bestLikelihoodIndex;
                this.bestLikelihoodIndex = (byte)i;
                continue;
            }
            if (this.secondBestLikelihoodIndex != -1 && !(this.likelihoods[i] > this.likelihoods[this.secondBestLikelihoodIndex])) continue;
            this.secondBestLikelihoodIndex = (byte)i;
        }
        this.firstAndSecondCalculated = true;
    }

    @Override
    public int getSequenceIndex() {
        return this.sequenceIndex;
    }

    public void setSequenceIndex(int sequenceIndex) {
        this.sequenceIndex = sequenceIndex;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public byte getReferenceBase() {
        return this.referenceBase;
    }

    public void setReferenceBase(byte referenceBase) {
        this.referenceBase = StringUtil.toUpperCase(referenceBase);
    }

    public int getNumReads() {
        return this.numReads;
    }

    public void setNumReads(int numReads) {
        this.numReads = numReads;
    }

    public short getMaxMappingQuality() {
        return this.maxMappingQuality;
    }

    public void setMaxMappingQuality(short maxMappingQuality) {
        this.maxMappingQuality = maxMappingQuality;
    }
}

