/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.linear;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.tribble.index.AbstractIndex;
import org.broad.tribble.index.Block;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.LittleEndianOutputStream;

public class LinearIndex
extends AbstractIndex
implements Index {
    private static final boolean ENABLE_ADAPTIVE_OPTIMIZATION = false;
    public static final int MAX_FEATURES_PER_BIN = 500;
    private static Logger log = Logger.getLogger(LinearIndex.class);

    public LinearIndex() {
    }

    public LinearIndex(List<ChrIndex> indicies, File inputFile) {
        super(inputFile.getAbsolutePath());
        for (ChrIndex index : indicies) {
            this.chrIndeces.put(index.getName(), index);
        }
    }

    private LinearIndex(LinearIndex parent, List<ChrIndex> indicies) {
        super(parent);
        for (ChrIndex index : indicies) {
            this.chrIndeces.put(index.getName(), index);
        }
    }

    public LinearIndex(String featureFile) {
        super(featureFile);
    }

    @Override
    protected int getType() {
        return IndexFactory.IndexType.LINEAR.getHeaderValue();
    }

    @Override
    public LinkedHashSet<String> getSequenceNames() {
        return this.chrIndeces == null ? new LinkedHashSet<String>() : new LinkedHashSet(this.chrIndeces.keySet());
    }

    @Override
    public Class getIndexClass() {
        return ChrIndex.class;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LinearIndex)) {
            return false;
        }
        LinearIndex other = (LinearIndex)obj;
        return super.equals(other);
    }

    public Index optimize(int threshold) {
        return this;
    }

    public Index optimize() {
        return this.optimize(500);
    }

    public static class ChrIndex
    implements org.broad.tribble.index.ChrIndex {
        private String name = "";
        private int binWidth;
        private int longestFeature;
        private int nFeatures;
        private List<Block> blocks;
        private static final int MAX_BIN_WIDTH = 1000000000;

        public ChrIndex() {
        }

        ChrIndex(String name, int binWidth) {
            this.name = name;
            this.binWidth = binWidth;
            this.blocks = new ArrayList<Block>(100);
            this.longestFeature = 0;
            this.nFeatures = 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        void addBlock(Block block) {
            this.blocks.add(block);
        }

        public int getNBlocks() {
            return this.blocks.size();
        }

        @Override
        public List<Block> getBlocks() {
            return this.blocks;
        }

        @Override
        public List<Block> getBlocks(int start, int end) {
            if (this.blocks == null || this.blocks.isEmpty()) {
                return null;
            }
            int adjustedPosition = Math.max(start - this.longestFeature, 0);
            int startBinNumber = Math.min(adjustedPosition / this.binWidth, this.blocks.size() - 1);
            int endBinNumber = Math.min(end / this.binWidth, this.blocks.size() - 1);
            return this.blocks.subList(startBinNumber, endBinNumber + 1);
        }

        public void updateLongestFeature(int featureLength) {
            this.longestFeature = Math.max(this.longestFeature, featureLength);
        }

        public int getNFeatures() {
            return this.nFeatures;
        }

        public void incrementFeatureCount() {
            ++this.nFeatures;
        }

        @Override
        public void write(LittleEndianOutputStream dos) throws IOException {
            dos.writeString(this.name);
            dos.writeInt(this.binWidth);
            dos.writeInt(this.blocks.size());
            dos.writeInt(this.longestFeature);
            dos.writeInt(0);
            dos.writeInt(this.nFeatures);
            long pos = 0L;
            int size = 0;
            for (Block block : this.blocks) {
                pos = block.getStartPosition();
                size = block.getSize();
                dos.writeLong(pos);
            }
            dos.writeLong(pos + (long)size);
        }

        @Override
        public void read(LittleEndianInputStream dis) throws IOException {
            this.name = dis.readString();
            this.binWidth = dis.readInt();
            int nBins = dis.readInt();
            this.longestFeature = dis.readInt();
            dis.readInt();
            this.nFeatures = dis.readInt();
            this.blocks = new ArrayList<Block>(nBins);
            long pos = dis.readLong();
            for (int binNumber = 0; binNumber < nBins; ++binNumber) {
                long nextPos = dis.readLong();
                int size = (int)(nextPos - pos);
                this.blocks.add(new Block(pos, size));
                pos = nextPos;
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ChrIndex)) {
                return false;
            }
            ChrIndex other = (ChrIndex)obj;
            return this.binWidth == other.binWidth && this.longestFeature == other.longestFeature && this.nFeatures == other.nFeatures && this.name.equals(other.name) && ((Object)this.blocks).equals(other.blocks);
        }

        public int getTotalSize() {
            int n = 0;
            for (Block b : this.getBlocks()) {
                n += b.getSize();
            }
            return n;
        }

        public double getAverageFeatureSize() {
            return 1.0 * (double)this.getTotalSize() / (double)this.getNFeatures();
        }

        public double getFeaturesPerBlock() {
            return 1.0 * (double)this.getNFeatures() / (double)this.getNBlocks();
        }

        private double getNFeaturesOfMostDenseBlock(double featureSize) {
            double m = -1.0;
            for (Block b : this.getBlocks()) {
                double n = (double)b.getSize() / featureSize;
                if (m != -1.0 && !(n > m)) continue;
                m = n;
            }
            return m;
        }

        private double optimizeScore() {
            return this.getNFeaturesOfMostDenseBlock(this.getAverageFeatureSize());
        }

        public ChrIndex optimize(int threshold) {
            return ChrIndex.optimize(this, threshold, 0);
        }

        private static ChrIndex optimize(ChrIndex idx, int threshold, int level) {
            ChrIndex best;
            block1: {
                best = idx;
                do {
                    double score = idx.optimizeScore();
                    log.debug(String.format("  %s%6s with %8d bins of size %6d: feature size est.  is %.2f, features per block %.5f, most dense %.5f, score %.5f", ChrIndex.dupString(' ', level * 2), idx.getName(), idx.getNBlocks(), idx.binWidth, idx.getAverageFeatureSize(), idx.getFeaturesPerBlock(), idx.getNFeaturesOfMostDenseBlock(idx.getAverageFeatureSize()), score));
                    if (score > (double)threshold || idx.getNBlocks() == 1 || idx.binWidth > 1000000000 || idx.binWidth < 0) break block1;
                    best = idx;
                    idx = ChrIndex.mergeBlocks(idx);
                } while (++level <= 30);
                throw new IllegalStateException("Too many iterations");
            }
            return best;
        }

        private static ChrIndex mergeBlocks(ChrIndex idx) {
            ChrIndex merged = new ChrIndex(idx.name, idx.binWidth * 2);
            merged.longestFeature = idx.longestFeature;
            merged.nFeatures = idx.nFeatures;
            Iterator<Block> blocks = idx.getBlocks().iterator();
            if (!blocks.hasNext()) {
                throw new IllegalStateException("Block iterator cannot be empty at the start for " + idx.getName());
            }
            while (blocks.hasNext()) {
                Block b2;
                Block b1 = blocks.next();
                Block block = b2 = blocks.hasNext() ? blocks.next() : null;
                if (b2 == null) {
                    merged.addBlock(b1);
                    continue;
                }
                merged.addBlock(new Block(b1.getStartPosition(), b1.getSize() + b2.getSize()));
            }
            return merged;
        }

        private static String dupString(char c, int nCopies) {
            char[] chars = new char[nCopies];
            Arrays.fill(chars, c);
            return new String(chars);
        }
    }
}

