SET SHOWMODE OFF
SET VERIFY OFF
SET ECHO OFF
SET PAGESIZE 0
SET NEWPAGE NONE
SET TIMING OFF
SET COLSEP " "
SET TRIMSPOOL ON
SET LINESIZE 1000
SET FEEDBACK OFF
SET TERMOUT OFF

spool hung_picard_aggregation_workflow_report.xls

select 'workflow_id' || chr(9) || 'server_host_name' || chr(9) || 'start_date' || chr(9) || 'status' || chr(9) || 'aggregation_parameters'
|| chr(9) || 'project' || chr(9) || 'sample_alias' || chr(9) || 'version' from dual
;

select w.workflow_id || chr(9) || chr(9) ||
       server_host_name || chr(9) || chr(9) ||
       start_date || chr(9) ||
       wss.name || chr(9) ||
       p.value || chr(9) ||
       p2.value || chr(9) ||
       p3.value || chr(9) ||
       p4.value
from workflow w
join workflow_step ws on ws.workflow_id = w.workflow_id
join workflow_step_status wss on ws.status_id = wss.status_id
left join workflow_step_param p on p.step_id = ws.step_id and p.param_descr_id = 510
left join workflow_step_param p2 on p2.step_id = ws.step_id and p2.param_descr_id = 511
left join workflow_step_param p3 on p3.step_id = ws.step_id and p3.param_descr_id = 512
left join workflow_step_param p4 on p4.step_id = ws.step_id and p4.param_descr_id = 513
where ws.name = 'picardAggregationWorkflow' and ws.status_id < 13 and start_date < (SYSDATE - 2)
order by start_date asc
;

exit
