SET SHOWMODE OFF
SET VERIFY OFF
SET ECHO OFF
SET PAGESIZE 0
SET NEWPAGE NONE
SET TIMING OFF
SET COLSEP " "
SET TRIMSPOOL ON
SET LINESIZE 1000
SET FEEDBACK OFF
SET TERMOUT OFF

spool hung_picard_reanalysis_workflow_report.xls

select 'run_id' || chr(9) || 'workflow_id' || chr(9) || 'server_host_name' || chr(9) || 'start_date' || chr(9) || 'status' || chr(9) || 'run_barcode'
from dual
;

select r.run_id || chr(9) ||
       w.workflow_id || chr(9) || chr(9) ||
       server_host_name || chr(9) || chr(9) ||
       start_date || chr(9) ||
       wss.name || chr(9) ||
       r.name
from next_generation_run r
join workflow w on w.run_id = r.run_id or w.run_barcode = r.barcode
join workflow_step ws on ws.workflow_id = w.workflow_id
join workflow_step_status wss on ws.status_id = wss.status_id
where ws.name = 'picardReanalysisWorkflow' and ws.status_id < 13 and start_date < (SYSDATE - 2)
order by start_date asc
;

exit
