#!/usr/bin/env python
# The Broad Institute
# SOFTWARE COPYRIGHT NOTICE AGREEMENT
# This software and its documentation are copyright 2006 by the
# Broad Institute/Massachusetts Institute of Technology. All rights are
# reserved.

# This software is supplied without any warranty or guaranteed support
# whatsoever. Neither the Broad Institute nor MIT can be responsible for its
# use, misuse, or functionality.
# $Header$

from __future__ import division
import subprocess
import sys

strSVNURL= "https://svnrepos/picard/branches"

def compareVersions(strV1, strV2):
    lst1 = [int(val) for val in strV1.split(".")]
    lst2 = [int(val) for val in strV2.split(".")]
    iCmp = cmp(lst1[0], lst2[0])
    if iCmp != 0:
        return iCmp
    return cmp(lst1[1], lst2[1])

def main(argv=None):
    if argv is None:
        argv = sys.argv

    proc = subprocess.Popen(("svn", "list", strSVNURL), stdout=subprocess.PIPE)

    (strStdout, strStderr) = proc.communicate()
    if proc.wait() != 0:
        raise Exception("svn list returned " + str(proc.returncode))
    lstVersions = strStdout.split("\n")
    lstVersions = [strVersion.rstrip("/") for strVersion in lstVersions if len(strVersion) > 0]
    lstVersions.sort(compareVersions)
    print "\n".join(lstVersions)
    
    

if __name__ == "__main__":
    sys.exit(main())
    
