#! /bin/bash
# The Broad Institute
# SOFTWARE COPYRIGHT NOTICE AGREEMENT
# This software and its documentation are copyright 2009 by the
# Broad Institute/Massachusetts Institute of Technology. All rights are
# reserved.

# This software is supplied without any warranty or guaranteed support
# whatsoever. Neither the Broad Institute nor MIT can be responsible for its
# use, misuse, or functionality.

# Definitions that get sourced into other scripts

SVNROOT='https://svn.broadinstitute.org/picard'
PICARDROOT=/seq/software/picard
BUILDROOT=$PICARDROOT/build
GATK_SVN_ROOT='https://svnrepos.broadinstitute.org/Sting'
GATK_SVN_TAG_ROOT=$GATK_SVN_ROOT/tags/picard
GATK_BUILD_ROOT=$BUILDROOT/gatk

function branch_exists() {
    if svn info $SVNROOT/branches/$1 2>&1 | fgrep -q 'Not a valid URL'
        then return 1
        else return 0
    fi
}

function gatk_tag_exists() {
    if svn info $GATK_SVN_TAG_ROOT/$1 2>&1 | fgrep -q 'Not a valid URL'
        then return 1
        else return 0
    fi
}

