#!/bin/bash

# Figure out a few things
FC=`grep -h FLOWCELL_BARCODE 1/*/params.txt | sort -u | sed 's/FLOWCELL_BARCODE=//'`
if echo $FC | grep "ABXX$" >> /dev/null; then TILES=340; else TILES=120; fi

echo
echo ">> Run Name"
echo ">> ========"
grep -h RUN_NAME */*/params.txt | sort -u | sed 's/RUN_NAME=//'

echo
echo ">> Lanes are from initiative(s):"
echo ">> ============================="
grep -h INITIATIVE */*/params.txt | cut -d= -f2 | sort | uniq -c

echo
echo \>\> Triage Results
echo \>\> ==============
for file in */*/params.txt; do java -jar `which TriageAnalysis.jar` OPTIONS_FILE=$file; done

echo
echo \>\> Lane Densities
echo \>\> ==============
echo L Density %PF
egrep '(UNPAIRED|FIRST_OF_PAIR)' */*/*.alignment_summary_metrics | awk "{print FNR, \$2/$TILES, \$4}"

echo
echo \>\> Internal Control Error Rates
echo \>\> ============================
grep Total */*/*.internal_control_summary_metrics | sed 's/\/.*\:/\t/' | column -t

echo
echo \>\> Alignment Rates
echo \>\> ===============
tmpfile=`mktemp`
echo -e "L CLUSTERS PCT_PF_READS R1_ALIGN% R1_ERROR% R2_ALIGN% R2_ERROR%" >> $tmpfile
for file in */*/*.alignment_summary_metrics; do
    echo `egrep -H '(FIRST_OF_PAIR|UNPAIRED)' $file | sed 's/\/.*:/\t/'| sed 's/\?/0/g' | cut -f1,3,5,8,13` `egrep '(SECOND_OF_PAIR)' $file | sed 's/\?/0/g' | cut -f7,12` | tr ' ' '\t' >> $tmpfile
done
cat $tmpfile | column -t
rm $tmpfile

echo
echo \>\> Fingerprint Stats
echo \>\> =================
for file in */*/*.summary_fingerprint_metrics; do head -8 $file | tail -1; done | column -t
