package org.broadinstitute.cga.tools.seq;

import org.broadinstitute.cga.tools.seq.BamGraspMine;
import org.broadinstitute.cga.tools.seq.BlastAligner;
import org.broadinstitute.cga.tools.seq.SubstringAligner;
import org.broadinstitute.cga.tools.seq.HashAligner;
import org.broadinstitute.cga.tools.seq.BowtieAligner;
import org.broadinstitute.cga.tools.seq.VELVETassembler;
import net.sf.samtools.*;
import java.io.*;
import java.lang.*;
import java.util.*;

public class AssembleRegions {
    
    private static final String usage =
	"Usage: AssembleRegions <BAMFilename> <BlacklistFilename> <TargetFasta> <KeyLen> <ValRes> <AllowOneMismatch> "+
	                   "<Chromosome> <OutFilestem>\n"+
	"   <BAMFilename> = name of bam to preprocess\n"+
	"   <BlacklistFilename> = file listing blacklisted lanes e.g. '42ABC.1' -- or specify 'none'\n"+
	"   <TargetFasta> = fasta file with sequences to look for\n"+
	"   <KeyLen> = length of keys to add to hash (should be major readlength of BAMfile)\n"+
	"   <ValRes> = binning resolution for values (i.e. positions in TargetFasta)\n"+
	"   <AllowOneMismatch> = if 1, will also hash every single-mismatch version of each key\n"+
	"   <Chromosome> = chromosome to process (1-24)\n"+      
	"   <OutFilestem> = filestem for output files\n";
    
    // parameters and input/output files
    
    private static String bamname = null;
    private static String blacklistname = null;
    private static int startreg = 0;
    private static int stopreg = 0;
    private static int keylen = 0;
    private static int chr = 0;
    private static String outstem = null;

    private static BamGraspMine bam = null;
    private static BamGraspMine bam2 = null;
    private static SAMFileReader reader = null;
    private static SAMRecordIterator c = null;

    // info about current read
    
    private static int mate_chr=0, mate_start=0, this_chr=0, this_start=0;
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    public static void main(String args[]) throws Exception {
	
	process_args(args);
	
	// open input file to create file of all reads
	open_input_file();

	int bsz = 10000;
	String readstem = "/xchip/cga1/ehelman/Transposons/reads/";
	String path[] = outstem.split("/");
	String name = path[path.length-1];
	String fold = path[path.length-2];
	String type[] = fold.split("_");
	String tum = type[0];
	String n[] = name.split("-");
	String ind = n[0];
	for(int i =1; i < n.length-1;i++)
		ind = ind + "-" +  n[i];
	System.out.println("ind is "+ind);
	String outname3 = readstem + tum + "/" + "assembly/" + name + ".chr" + chr + ".region." + startreg + "-" + stopreg + ".txt";
	System.out.println("reads for assembly are in " + outname3);
	File rf = new File(outname3);
	if(rf.exists()) System.out.println("Reads file exists");
	else {
		String outnametemp3 = outname3 + ".partial";
	
		BufferedWriter out3 = new BufferedWriter(new FileWriter(outnametemp3),bsz);
		System.out.println("starting to read");

		while( c.hasNext() ) {
			SAMRecord x = c.next();
			
			if (x.getDuplicateReadFlag()) continue;
			if (x.getNotPrimaryAlignmentFlag()) continue;
			if (!x.getReadPairedFlag()) continue;
			if (bam.isReadGroupBlacklisted(x.getAttribute("RG").toString())) continue;
			
			//String seq = x.getReadString();
			//if(seq.length() != 101) continue;
		 	
			SAMRecord mate = bam2.reader.queryMate(x);
			bam.parse(x,mate);
			if (bam.read.isweird()) {
			   String seq = mate.getReadString();
			   out3.write(">\n" + seq + "\n");
			}
		}
		bam.close();
		bam2.close();
		out3.close();
		File f1 = new File(outnametemp3);
		f1.renameTo(new File(outname3));
	}


	// Assemble 
	open_input_file();     
	
	String maindir = "/xchip/cga1/ehelman/Transposons/";
	String assemblepath = maindir + fold +"/" + ind + ".assembly/" + name + ".chr" + chr + ".region." + startreg + "-" + stopreg + ".assembly";
	String assembled = assemblepath + "/contigs.fa"; 
	File af = new File(assembled);
	//if(af.exists()) System.out.println("Aligned file already exists");
	//else {
		Assembler aa = new VELVETassembler(outname3,assemblepath,keylen);
		aa.assemble();
	//}

	// done
	bam.close();
	bam2.close();

    } // end of main()
    
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    private static void process_args(String args[]) throws Exception {
	if (args.length!=7) {
            System.out.print(usage);
            System.exit(1);
        }
	int a = 0;
	bamname = args[a++];
	blacklistname = args[a++];
	//targetfasta = args[a++];
	keylen = Integer.valueOf(args[a++]);
        startreg = Integer.valueOf(args[a++]);
	stopreg = Integer.valueOf(args[a++]);
	//valres = Integer.valueOf(args[a++]);
	//allowonemismatch = Integer.valueOf(args[a++]);
        chr = Integer.valueOf(args[a++]);
	if (chr<1 || chr>24) throw new Exception("chr should be 1-24");
	outstem = args[a++];
    }
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    private static void open_input_file() throws Exception {
	bam = new BamGraspMine(bamname,blacklistname);
	bam2 = new BamGraspMine(bamname,blacklistname);
	String seqname = bam.getChrName(chr);
	c = bam.reader.queryContained(seqname,startreg,stopreg);
    }
    
}
