## Load source code
args=(commandArgs(TRUE))

##args is now a list of character vectors
## First check to see if arguments are passed.
## Then cycle through each element of the list and evaluate the expressions.
if(length(args)==0){
    print("No arguments supplied.")
}else{
    for(i in 1:length(args)){
         eval(parse(text=args[[i]]))
    }
}
print(tum)
print(fasta)
print(fastafile)
print(samp)
print(bam)
print(c)
print(startpos)
print(stoppos)
print(outstem)
print(t)
print(percentident)
print(nalign)
print(evalue)
print(queue)
print(lsfdir)


aligner = "BLAST"
print(aligner)

source("functions.R")
reffilesdir = paste(getwd(),"/reffiles/",sep="")
print(paste("Working directory is",getwd(),sep=""))

Sys.setenv(TMPDIR="/xchip/cga4/home/ehelman/tmp/")
##
## Write weird reads
##
## Use java class WriteReads.java
## Launch java job and wait for it to finish before moving on

GetReads = function (tum,samp,fasta,bam,blacklist,c,refdir,readsdir,outstem,t,queue,percentident,nalign,evalue) {
	chr = substring(c,1,nchar(c)-1)
	print(chr)

	if(queue == "hour")
		queue = "hour -W 4:00"

	readsfile = paste(readsdir,samp,"-",t,".chr",c,".reads.txt",sep="")
	
	if(!file.exists(readsfile)) {
	jobname = paste(samp,c,"WR",sep="_")
	groupname = paste("/",samp,"_WR",sep="")
	classpath = paste(reffilesdir,"sam.jar:",getwd(),"/classes",sep="")
	cmd = paste("bsub -E \"sleep 10;cd /xchip/cga1;cd /home/radon00\" -q hour -W 4:00 -g",groupname,"-o ",paste(lsfdir,"%J.out",sep="")," -r -R \"rusage[iron_io=30]\" -J",jobname,
	"java -Xmx2g -classpath",classpath,"org.broadinstitute.cga.tools.seq.WriteReads",
	bam,blacklist,fasta,tum,percentident,refdir,readsdir,chr,startpos,stoppos,outstem,sep=" ")
	print(cmd)
	system(cmd)

	while ( system(paste("bjobs -J ", jobname, " | wc -l"), intern=T)>0 )
  	{
    	 Sys.sleep(30)
  	}

	if (!file.exists(readsfile) & file.exists(paste(readsfile,".partial",sep=""))) {
		cmd = paste("mv ",readsfile,".partial ",readsfile,".error",sep="")
		system(cmd)
		stop("Writing reads ended but file not created!")
	}
	
	print("Done writing reads!")
	} else print("Reads file already exists")



##
## Align reads with BLAST
##
if(aligner == "BLAST") {

	fastaformat = paste(fasta,".nsq",sep="")

	blastedfile = paste(outstem,".chr",c,".reads.aligned.txt",sep="")
	parsedfile = paste(outstem,".chr",c,".reads.aligned.txtparsed.txt",sep="")

	if(!file.exists(blastedfile) && !file.exists(parsedfile) && !file.exists(paste(parsedfile,".used",sep=""))) {
		if(!file.exists(fastaformat)) {
			#cmd = paste("formatdb -i ",fasta," -p F",sep="")
			cmd = paste("/xchip/cga/ehelman/ncbi-blast-2.2.27+/bin/makeblastdb -dbtype 'nucl' -in ",fasta,sep="")
			system(cmd)
		}
		cmd = paste("/xchip/cga/ehelman/ncbi-blast-2.2.27+/bin/blastn -query ",readsfile," -task blastn -db ",fasta," -evalue 0.5 -outfmt 6 -dbsize 3000000 -dust 'no' -soft_masking 'false' -perc_identity 90 -culling_limit 1 -out ",blastedfile,sep="")
		#cmd = paste("blastall -p blastn -i ",readsfile," -d ",fasta," -F F -m 8 -o ",blastedfile,".partial",sep="")
		print(cmd)
		system(cmd)

		system(paste("mv ",paste(blastedfile,".partial",sep="")," ",blastedfile,sep=""))

		while (!file.exists(blastedfile))
			Sys.sleep(30)

	print("Done blasting reads!")
	} else print("Blasted file already exists")
}
if(aligner == "bowtie") {

        fastaformat = paste(fasta,".1.ebwt",sep="")

        blastedfile = paste(outstem,".chr",c,".reads.aligned.txt",sep="")
        parsedfile = paste(outstem,".chr",c,".reads.aligned.txtparsed.txt",sep="")
	if(!file.exists(blastedfile) && !file.exists(parsedfile) && !file.exists(paste(parsedfile,".used",sep=""))) {
                if(!file.exists(fastaformat)) {
                        #cmd = paste("formatdb -i ",fasta," -p F",sep="")
                        cmd = paste("bowtie-build ",fasta," ",fasta,sep="")
                        system(cmd)
                }
                cmd = paste("bowtie -f --best --suppress 6 --quiet ",fasta," ",readsfile," ",blastedfile,sep="")
                #cmd = paste("blastall -p blastn -i ",readsfile," -d ",fasta," -F F -m 8 -o ",blastedfile,".partial",sep="")
                print(cmd)
                system(cmd)

                system(paste("mv ",paste(blastedfile,".partial",sep="")," ",blastedfile,sep=""))

                while (!file.exists(blastedfile))
                        Sys.sleep(30)

        print("Done bowting reads!")
        } else print("Bowtied file already exists")

}

##
## Format weird, aligned reads
##
	weirdfile = paste(outstem,".chr",c,".weird.txt",sep="")
	parsedfile = paste(outstem,".chr",c,".reads.aligned.txtparsed.txt",sep="")

	if( !file.exists(parsedfile) && !file.exists(paste(parsedfile,".used",sep=""))) {
	jobname = paste(samp,c,"FW",sep="_")
	classpath = paste(reffilesdir,"sam.jar:",getwd(),"/classes",sep="")
	#queue = "week"
	if(aligner == "BLAST") scriptname = "FormatWeirds"	
	if(aligner == "bowtie") scriptname = "FormatWeirds_Bowtie"
	cmd = paste("bsub -E \"sleep 10;cd /xchip/cga1;cd /home/radon00\" -q hour -W 4:00 -o ",paste(lsfdir,"%J.out",sep="")," -J",jobname,
	"java -Xmx4g -XX:+UseConcMarkSweepGC -classpath",classpath,paste("org.broadinstitute.cga.tools.seq.",scriptname,sep=""),
	bam,blacklist,fasta,tum,percentident,nalign,evalue,refdir,readsdir, chr,startpos,stoppos,outstem,sep=" ")
	print(cmd)
	
	system(cmd)

	while ( system(paste("bjobs -J ", jobname, " | wc -l"), intern=T)>0 )
 	 {
     	Sys.sleep(30)
  	}

	print("Done writing reads!")
	} else print("Formated weird file exists")

}

GetReads(tum,samp,fastafile,bam,blacklist,c,refdir,readsdir,outstem,t,queue,percentident,nalign,evalue)
