package org.broadinstitute.cga.tools.seq;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMFileReader.ValidationStringency;

public class MakeLanelist {
	public static void main(final String args[]) throws IOException {
		SAMFileReader.setDefaultValidationStringency(ValidationStringency.SILENT);
		if (args.length!=2) {
			System.out.println("Usage: MakeLanelist <BAMFilename> <OutFilename>");
			System.exit(1);
		}

		final String bamFilename = args[0];
		final String outFilename = args[1];

		final SAMFileReader r = new SAMFileReader(new File(bamFilename));
		final BufferedWriter out = new BufferedWriter(new FileWriter(outFilename));

		// attribs to capture
		final String[] attribs = {"ID","CN","PL","SM","LB","PU","DT","PI","DS"};

		// write header line
		out.write("lane");
		for (final String a : attribs) {
			out.write("\t" + a);
		}
		out.write("\n");

		// process list of readgroups
		int i = 0;     // ZERO-BASED!
		for (final SAMReadGroupRecord readGroup : r.getFileHeader().getReadGroups()) {
			out.write("" + i++);
			for (final String a : attribs) {
				Object o = null;
				if (a.equals("ID")) { o = readGroup.getReadGroupId(); }
				else { o = readGroup.getAttribute(a); }
				String v = "null";
				if (o != null) { v = o.toString(); }
				out.write("\t" + v);
			}
			out.write("\n");
		}
		out.close();
		System.exit(0);
	}
}
