##
## Run TranspoSeq with input parameters
##

## use R-2.10
## use LSF
## use BLAST


source("functions.R")

print("Starting Transposeq with inputs:")

## Set default parameters
hgnum=19
nalign=27
percentident=90
evalue=1E-06

## Load arguments code
args=(commandArgs(TRUE))

if(length(args)==0){
    print("No arguments supplied.")
}else{
    for(i in 1:length(args)){
         eval(parse(text=args[[i]]))
    }
}
print(tum)
print(samp)
print(fastafile)
print(tumorbam)
print(normalbam)
print(samp)
print(hgnum)
print(fasta)
print(queue)
print(evalue)
print(nalign)
print(percentident)




##
## Retrotransposon fasta database to align to
##
print("Checking fasta file existence")
if(!file.exists(fastafile)) {
	print("Fasta file does not exist")
	break
}

print("Ensuring output directories..")

##
## Output directories
##
ensure_dir_exists(dir)

ensure_dir_exists(readsfold)

ldir = paste(dir,"lsf/",sep="")
ensure_dir_exists(ldir)
lsfdir = paste(ldir,samp,"/",sep="")
ensure_dir_exists(lsfdir)


## 
## BAM files
##

#if(length(tumorbam) == 0 || length(normalbam) == 0 ||!file.exists(tumorbam) || !file.exists(normalbam)) {
#	print("A file does not exist")
#	break		
#}
	
	
##
## Start job
##
jobname = paste(tum,fasta,samp,"TS",sep="_")

while ( system(paste("bjobs -J ", jobname, " | wc -l"), intern=T)>0 )
    Sys.sleep(60)

script = "Run_TranspoSeq.R"

cmd = paste("bsub -q ",queue," -J ",jobname," -o ",paste(lsfdir,tum,"_",fasta,".out",sep="")," -R \"rusage[mem=4]\" R CMD BATCH --no-save --no-restore '--args tum=\"",tum,"\" samp=\"",samp,"\" fastafile=\"",fastafile,"\" tumorbam=\"",tumorbam,"\" normalbam=\"",normalbam,"\" hgnum=\"",hgnum,"\" fasta=\"",fasta,"\" dir=\"",dir,"\" readsfold=\"",readsfold,"\" queue=\"",queue,"\" evalue=\"",evalue,"\" nalign=\"",nalign,"\" nreads=\"",nreads,"\" percentident=\"",percentident,"\"' ",script," ", paste(lsfdir,script,"_",tum,"_",samp,"_",fasta,".out",sep=""),sep="")

cat(cmd)
system(cmd)


print("TranspoSeq launched")


