package org.broadinstitute.cga.tools.seq;

import org.broadinstitute.cga.tools.seq.Fasta;
import org.broadinstitute.cga.tools.seq.BLASTreader;

import java.io.*;
import java.lang.*;
import java.util.*;

public class VELVETassembler extends Assembler{

    public VELVETassembler() {
    	System.out.println("Velvet assembler");
    }
    public VELVETassembler(String readFile, String assemblePath) throws Exception {
    	readfile = readFile;
	assemblepath = assemblePath;
	loadSeqs(13);
	}

    public VELVETassembler(String readFile, String assemblePath, int keyLength) throws Exception {
	readfile = readFile;
	assemblepath = assemblePath;
	keylen = keyLength;
	loadSeqs(keylen);
    }

    private boolean ready = false;
    private String assemblepath;
    private String readfile;
    private int keylen;
    public String dbstem = "/xchip/cga1/ehelman/Transposons/db/";
    public String velvet = "/xchip/cga1/ehelman/Transposons/velvet_1.0.18/velvetg"; 
    public String velvetbuild = "/xchip/cga1/ehelman/Transposons/velvet_1.0.18/velveth";
    
    public void assemble() throws Exception {
	try {
		String command = velvet + "  "+ assemblepath + " -cov_cutoff 1";
		System.out.println(command);
		Process p = Runtime.getRuntime().exec(command);
		p.waitFor();
		
	}
	catch(Exception ex) {ex.printStackTrace();}
		
    }
    
    private void loadSeqs(int keylen) throws Exception {

	// check if velvet seq db already exists
	File f = new File(assemblepath); 
	if(!f.exists()) {
		f.mkdir();
		System.out.println("Making velvet seq db at " + assemblepath);
		String command = velvetbuild + " " + assemblepath +" " + keylen +" "+ readfile;
		System.out.println(command);
		Process p = Runtime.getRuntime().exec(command);
		p.waitFor();
	} else {
	System.out.println("Velvet db exists at" + assemblepath);
	}
	ready = true;
    }

}    
