package org.broadinstitute.cga.tools.seq;

import org.broadinstitute.cga.tools.seq.BamGraspMine;
import org.broadinstitute.cga.tools.seq.BowtieAligner;
import net.sf.samtools.*;
//import net.sf.samtools.BAMFileWriter;
import java.io.*;
import java.lang.*;
import java.util.*;

public class  WriteReads {
    
    private static final String usage =
	"Usage: WriteReads <BAMFilename> <BlacklistFilename> <TargetFasta> <Tumor> <Mismatches> "+
	                   "<Refdir> <Chromosome> <OutFilestem>\n"+
	"   <BAMFilename> = name of bam to preprocess\n"+
	"   <BlacklistFilename> = file listing blacklisted lanes e.g. '42ABC.1' -- or specify 'none'\n"+
	"   <TargetFasta> = fasta file with sequences to look for\n"+
	"   <Tumor> = tumor type\n"+
	"   <AllowOneMismatch> = if 1, will also hash every single-mismatch version of each key\n"+
	"   <Refdir> = reference genome assembly file" + 
	"   <Chromosome> = chromosome to process (1-24)\n"+      
	"   <OutFilestem> = filestem for output files\n";
    
    // parameters and input/output files
    
    private static String bamname = null;
    private static String blacklistname = null;
    private static String targetfasta = null;
    private static String tumor = null;
    private static String refdir = null;
    private static String readsdir = null;
    private static int percentident = 0;
    private static int chr = 0;
    private static int startpos = 0;
    private static int stoppos = 0;
    private static String outstem = null;

    private static BamGraspMine bam = null;
    private static BamGraspMine bam2 = null;
    //private static BAMFileWriter newbamfile = null;   
    private static SAMFileReader reader = null;
    private static SAMRecordIterator c = null;

    // info about current read
    
    private static int mate_chr=0, mate_start=0, this_chr=0, this_start=0;
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    public static void main(String args[]) throws Exception {
	
	process_args(args);
	
	// open input file to create file of all reads
	open_input_file();

	int bsz = 10000;
	String path[] = outstem.split("/");
	String name = path[path.length-1];
	String fold = path[path.length-2];
	String arm;
	if(startpos == 1) arm = "p";
	else arm = "q";
	
	System.out.println(startpos);
	System.out.println(arm);
	String outname3 = readsdir + name + ".chr" + chr + arm + ".reads.txt";
	
	// Keep track of all reads and events seen
	int nDupFlag = 0;
	int nNotPrimFlag = 0;
	int nNotReadFlag = 0;
	int nBlackList = 0;
	int nReadLength = 0;
	int abnormreadlength = 0;
	
	File rf = new File(outname3);
	if(rf.exists()) System.out.println("Reads file exists");
	else {
		String outnametemp3 = outname3 + ".partial";
	
		BufferedWriter out3 = new BufferedWriter(new FileWriter(outnametemp3),bsz);
		System.out.println("Starting to read BAM file...");
		
		int counter = 0;
		while( c.hasNext() ) {
			SAMRecord x = c.next();
			counter++;	
			if (x.getDuplicateReadFlag()) {
				//System.out.println("duplicate read flag");
				nDupFlag++;
				continue; }
			if (x.getNotPrimaryAlignmentFlag()) {
				//System.out.println("not primary alignment flag");
				nNotPrimFlag++;
				continue; }
			if (!x.getReadPairedFlag()) {
				//System.out.println("not get read paired flag");
				nNotReadFlag++;
				continue; }
			if (bam.isReadGroupBlacklisted(x.getAttribute("RG").toString())) {
				//System.out.println("blacklisted");
				nBlackList++;
				continue; }
			
			String seq = x.getReadString();
			if(seq.length() != 101) {
				nReadLength++;
				abnormreadlength = seq.length();	
				//continue;
		 	}
			bam.parse(x);
			
			// Abridge read name if too long
			String readname = x.getReadName();
			if(readname.length() > 60) {
				readname = readname.substring(0,59);
			}

			// If clipped beginning
			//System.out.println("spans breakpoint");			
			if( x.getAlignmentStart() != x.getUnclippedStart() ) {
				int endclip = x.getAlignmentStart()-x.getUnclippedStart();
				//byte firstbasephred = x.getBaseQualities()[0];
				// IF base phred quality of first base in clip is > 2 then keep it
				if ( endclip > 4 ) {
					int numpoorqual = 0;
					for(int j = 0; j <= 5; j++ ) {
						if( x.getBaseQualities()[j] < 10 )
							numpoorqual++;
					}
					if ( numpoorqual < 2) {
					out3.write(">"+counter+"|"+readname+"|"+bam.read.chr+"|"+x.getUnclippedStart()+"~"+
						readname+"|"+bam.read.chr+"|"+x.getUnclippedStart()+"~"+
						readname+"~"+bam.read.chr+"~"+x.getUnclippedStart()+"~"+x.getAlignmentStart()+"~"+x.getUnclippedEnd()+"~0~"+
						bam.read.strand+"~"+bam.read.mapqual+"~"+bam.read.whichpairmate+"\n");
					//clipped beginning = 0
					out3.write(x.getReadString().substring(0,endclip) + "\n");	
					}				
				}
			} 
				// If clipped end	
			if ( x.getAlignmentEnd() != x.getUnclippedEnd() ) {
				//System.out.println("clipped end");
				int startclip = x.getAlignmentEnd()-x.getUnclippedStart()+1;
				if(startclip > 100) continue;
				int sizeofclip = x.getUnclippedEnd()-x.getAlignmentEnd();
				int sizeofread = x.getUnclippedEnd()-x.getUnclippedStart()+1;
				//System.out.println(sizeofread);
				if(startclip+4 < x.getBaseQualities().length && startclip > -1 && sizeofclip > 4) {	
					//byte firstclipbasephred = x.getBaseQualities()[startclip];
					int numpoorqual = 0;
					for(int j = startclip; j <= startclip+4; j++ ) {
						if( x.getBaseQualities()[j] < 10 )
							numpoorqual++;
					}
					if ( numpoorqual < 2 ) {
					
						out3.write(">"+counter+"|"+readname+"|"+bam.read.chr+"|"+x.getUnclippedStart()+"~"+
							readname+"|"+bam.read.chr+"|"+x.getUnclippedStart()+"~"+
							readname+"~"+bam.read.chr+"~"+x.getUnclippedStart()+"~"+x.getAlignmentEnd()+"~"+x.getUnclippedEnd()+"~1~"+
							bam.read.strand+"~"+bam.read.mapqual+"~"+bam.read.whichpairmate+"\n");
						//clipped end = 1
						out3.write(x.getReadString().substring(startclip) + "\n");	

					}
				}	
			} 
			
				
		}
		System.out.println("nDupFlag is " + nDupFlag);
		System.out.println("nNotPrimFlag is " + nNotPrimFlag);
		System.out.println("nNotReadFlag is " + nNotReadFlag);
		System.out.println("nBlackList is " + nBlackList);
		System.out.println("nReadLength is " + nReadLength + " and abnormal read length example is " + abnormreadlength);
		System.out.println("totn is " + counter);
		bam.close();
		bam2.close();
		out3.close();
		File f1 = new File(outnametemp3);
		f1.renameTo(new File(outname3));
	}


	
    } // end of main()
    
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    private static void process_args(String args[]) throws Exception {
	if (args.length!=11) {
            System.out.print(usage);
            System.exit(1);
        }
	int a = 0;
	bamname = args[a++];
	blacklistname = args[a++];
	targetfasta = args[a++];
	tumor = args[a++];
	percentident = Integer.valueOf(args[a++]);
	refdir = args[a++];
	readsdir = args[a++];
        chr = Integer.valueOf(args[a++]);
	if (chr<1 || chr>24) throw new Exception("chr should be 1-24");
	startpos = Integer.valueOf(args[a++]);
	System.out.println(startpos);
	stoppos = Integer.valueOf(args[a++]);
	System.out.println(stoppos);
	outstem = args[a++];
    }
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    private static void open_input_file() throws Exception {
	bam = new BamGraspMine(bamname,blacklistname,refdir);
	bam2 = new BamGraspMine(bamname,blacklistname,refdir);
	String seqname = bam.getChrName(chr);
	c = bam.reader.queryContained(seqname,startpos,stoppos);
    }
    
}
