package org.broadinstitute.cga.tools.seq;

import java.io.*;
import java.lang.*;
import java.util.*;

public class Fasta {
    private String fname = null;
    private BufferedReader input = null;
    private boolean ready = false;
    private boolean seqready = false;
    private boolean lastseq = false;

    private String line = null;
    private String header = null;
    private String nextHeader = null;
    private String seq = null;

    private boolean quietFlag = false;

    public Fasta(boolean qf) {
	quietFlag = qf;
    }

    public Fasta() {
    }

    public Fasta(String filename, boolean qf) throws Exception {
	quietFlag = qf;
        open(filename);
    }

    public Fasta(String filename) throws Exception {
	open(filename);
    }

    public void open(String filename) throws Exception {
	fname = filename;
	rewind();
    }

    public void rewind() throws Exception {
	if (fname == null) throw new Exception("Need filename!");
	if (input != null) close();
	int bsz = 1000000;
	input = new BufferedReader(new FileReader(fname),bsz);
	ready = true;
	seqready = false;
	lastseq = false;
    }

    public void close() throws Exception {
	if (ready) {
	    input.close();
	    ready = false;
	    seqready = false;
	}
    }

    /////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////

    public String getSeq() throws Exception {
	if (!ready) throw new Exception("File not ready");
        if (!seqready) throw new Exception("Please call next() first");
	return(seq);
    }

    public String getHeader() throws Exception {
        if (!ready) throw new Exception("File not ready");
        if (!seqready) throw new Exception("Please call next() first");
        return(header);
    }

    /////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////

    public boolean next() throws Exception {
	if (!ready) throw new Exception("File not ready");
        if (lastseq) {     // previous sequence was the last one in the file
            close();
            return(false);
        }
	if (nextHeader==null) header = input.readLine();  // still on first line
	else header = nextHeader;
	if (header.charAt(0)!='>') throw new Exception("Invalid header line "+header);
	header = header.substring(1);
	seq = new String("");
	while(true) {
	    line = input.readLine();
	    if (line==null) {     // reached end of file
		lastseq = true;
		break;
	    }
	    if (line.length()==0) continue;   // skip blank lines
	    if (line.charAt(0)=='>') {   // stop at the next header, save it for next call
		nextHeader = line;
		break;
	    }
	    seq += line.replaceAll("\\W","");
	}	
	seqready = true;
	return(true);
    }

    /////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////


}
