package org.broadinstitute.cga.tools.seq;

import org.broadinstitute.cga.tools.seq.Fasta;
import org.broadinstitute.cga.tools.seq.BLASTreader;

import java.io.*;
import java.lang.*;
import java.util.*;

public class SubstringAligner extends Aligner {

    public SubstringAligner() {
    	System.out.println("blast aligner");
    }
    
    public SubstringAligner(String fastaFile,int allowOneMismatch) throws Exception {
	fastaseq = "";
	loadFasta(fastaFile, allowOneMismatch);
    }
    // fastaFile = fasta file to make ncbi db out of
    // allowOneMismatch = if true, hashes one additional key for each single-base mismatch version
    //
    // get() returns 0 for queries where nothing is found

    private static String fastaseq_rc;
    private static String fastaseq;

    public int align(String query) throws Exception {
	int posf=-1; int posr=-1;
	posf = fastaseq.indexOf(query);
	if(posf != -1) {
		return posf;
	} else	
		posr = fastaseq_rc.indexOf(query);
	if(posr != -1)
		return -posr;
	else return 0;	
    }
    
    private void loadFasta(String fastaFile,int allowOneMismatch) throws Exception {
	Fasta fs = new Fasta(fastaFile);
	while(fs.next())
		fastaseq = fs.getSeq().toUpperCase();
	fastaseq_rc = rc(fastaseq);
	System.out.println("fasta of length " + fastaseq.length() + " and rc of length " + fastaseq_rc.length() +" loaded");
    }
	
}
