package org.broadinstitute.cga.tools.seq;

import org.broadinstitute.cga.tools.seq.Fasta;
import java.io.*;
import java.lang.*;
import java.util.*;

public abstract class Assembler {

  //  public Assembler(String dictionaryFasta, int keyLen,
//		       int valResolution, boolean allowOneMismatch) throws Exception {
    //}
   
    // allign() returns 0 for queries where nothing is found

    private boolean ready = false;
    public boolean isReady() { return(ready); }

    
    private char[] bases = {'A','C','G','T'};

    public abstract void assemble() throws Exception; 

    public boolean isLegalSeq(String seq) {
	for (int i=0;i<seq.length();i++) {
	    char c = seq.charAt(i);
	    if (c!='A' && c!='C' && c!='G' && c!='T') return(false);
	}
	return(true);
    }

    public String rc(String seq) {
	int len = seq.length();
	StringBuffer rcseq = new StringBuffer(len);
	for (int i=len-1; i>=0; i--) {
	    rcseq.append(rc(seq.charAt(i)));
	}
	return rcseq.toString();
    }

    public char rc(char in) {
	if (in=='A') return('T');
	if (in=='C') return('G');
	if (in=='G') return('C');
	if (in=='T') return('A');
	return('N');
    }
}
