package org.broadinstitute.cga.tools.seq;

import org.broadinstitute.cga.tools.seq.Fasta;
import org.broadinstitute.cga.tools.seq.BLASTreader;

import java.io.*;
import java.lang.*;
import java.util.*;

public class BowtieAligner extends Aligner{

    public BowtieAligner() {
    	System.out.println("blast aligner");
    }
    
    public BowtieAligner(String fastaFile, String readFile, String alignFile, int allowOneMismatch) throws Exception {
	String s[] = fastaFile.split("/");
	String fastaf = s[s.length-1];
	fastaname = fastaf.split("\\.")[0];
	readfile = readFile;
	alignfile = alignFile;
	mismatch = allowOneMismatch;
	fastapath = dbstem+fastaname;
	loadFasta(fastaFile, allowOneMismatch);
    }
    // fastaFile = fasta file to make ncbi db out of
    // allowOneMismatch = if true, hashes one additional key for each single-base mismatch version
    //
    // align() returns 0 for queries where nothing is found

    private String fastaname; 
    private boolean ready = false;
    private String fastapath;
    private String readfile;
    private String alignfile;
    private int mismatch;
    public static BLASTreader breader;
    public String dbstem = "/xchip/cga1/ehelman/Transposons/db/";
    public String bowtie = "/xchip/cga1/ehelman/Transposons/bowtie-0.12.7/bowtie"; 
    public String bowtiebuild = "/xchip/cga1/ehelman/Transposons/bowtie-0.12.7/bowtie-build";
    
    public int align(String query) throws Exception {
	int pos = -100;
	try {
		String tempalignfile = alignfile + ".partial";
		String command = bowtie + " --best -v " + mismatch + " " + fastapath + " --suppress 6 --quiet -r " + readfile + " " + tempalignfile;
		System.out.println(command);
		Process p = Runtime.getRuntime().exec(command);
		p.waitFor();
		
		File a = new File(tempalignfile);
		a.renameTo(new File(alignfile));
		pos = 1;
		
	}
	catch(Exception ex) {ex.printStackTrace();}
		
	return(pos);
    }
    
    private void loadFasta(String fastaFile, int allowOneMismatch) throws Exception {

	// check if fasta db already exists
	File f = new File(fastapath+".1.ebwt");
	if(!f.exists()) {
		System.out.println("Making fasta db at " + fastapath);
		String command = bowtiebuild + " "+fastaFile+" "+fastapath;
		System.out.println(command);
		Process p = Runtime.getRuntime().exec(command);
		p.waitFor();
	} else {
	System.out.println("Fasta db exists at" + fastapath);
	}
	ready = true;
    }

}    
