/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import java.io.Serializable;

public class LUDecomposition
implements Serializable {
    private float[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(Matrix A) {
        this.LU = A.getArrayCopy();
        this.m = A.getRowDimension();
        this.n = A.getColumnDimension();
        this.piv = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            this.piv[i] = i;
        }
        this.pivsign = 1;
        float[] LUcolj = new float[this.m];
        for (int j = 0; j < this.n; ++j) {
            int i;
            int i2;
            for (i2 = 0; i2 < this.m; ++i2) {
                LUcolj[i2] = this.LU[i2][j];
            }
            i2 = 0;
            while (i2 < this.m) {
                float[] LUrowi = this.LU[i2];
                int kmax = Math.min(i2, j);
                float s = 0.0f;
                for (int k = 0; k < kmax; ++k) {
                    s += LUrowi[k] * LUcolj[k];
                }
                int n = i2++;
                float f = LUcolj[n] - s;
                LUcolj[n] = f;
                LUrowi[j] = f;
            }
            int p = j;
            for (i = j + 1; i < this.m; ++i) {
                if (!(Math.abs(LUcolj[i]) > Math.abs(LUcolj[p]))) continue;
                p = i;
            }
            if (p != j) {
                int k;
                for (k = 0; k < this.n; ++k) {
                    float t = this.LU[p][k];
                    this.LU[p][k] = this.LU[j][k];
                    this.LU[j][k] = t;
                }
                k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (!(j < this.m & (double)this.LU[j][j] != 0.0)) continue;
            for (i = j + 1; i < this.m; ++i) {
                float[] fArray = this.LU[i];
                int n = j;
                fArray[n] = fArray[n] / this.LU[j][j];
            }
        }
    }

    public boolean isNonsingular() {
        for (int j = 0; j < this.n; ++j) {
            if (this.LU[j][j] != 0.0f) continue;
            return false;
        }
        return true;
    }

    public Matrix getL() {
        Matrix X = new Matrix(this.m, this.n);
        float[][] L = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                L[i][j] = i > j ? this.LU[i][j] : (i == j ? 1.0f : 0.0f);
            }
        }
        return X;
    }

    public Matrix getU() {
        Matrix X = new Matrix(this.n, this.n);
        float[][] U = X.getArray();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                U[i][j] = i <= j ? this.LU[i][j] : 0.0f;
            }
        }
        return X;
    }

    public int[] getPivot() {
        int[] p = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            p[i] = this.piv[i];
        }
        return p;
    }

    public float[] getDoublePivot() {
        float[] vals = new float[this.m];
        for (int i = 0; i < this.m; ++i) {
            vals[i] = this.piv[i];
        }
        return vals;
    }

    public float det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        float d = this.pivsign;
        for (int j = 0; j < this.n; ++j) {
            d *= this.LU[j][j];
        }
        return d;
    }

    public Matrix solve(Matrix B) {
        int j;
        int i;
        int k;
        if (B.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int nx = B.getColumnDimension();
        Matrix Xmat = B.getMatrix(this.piv, 0, nx - 1);
        float[][] X = Xmat.getArray();
        for (k = 0; k < this.n; ++k) {
            for (i = k + 1; i < this.n; ++i) {
                for (j = 0; j < nx; ++j) {
                    float[] fArray = X[i];
                    int n = j;
                    fArray[n] = fArray[n] - X[k][j] * this.LU[i][k];
                }
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            int j2 = 0;
            while (j2 < nx) {
                float[] fArray = X[k];
                int n = j2++;
                fArray[n] = fArray[n] / this.LU[k][k];
            }
            for (i = 0; i < k; ++i) {
                for (j = 0; j < nx; ++j) {
                    float[] fArray = X[i];
                    int n = j;
                    fArray[n] = fArray[n] - X[k][j] * this.LU[i][k];
                }
            }
        }
        return Xmat;
    }
}

