/*
 * Decompiled with CFR 0.152.
 */
package com.community.xanadu.utils;

import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class WindowsUtils {
    public static void addCloseAction(Window window, final AbstractAction action) {
        if (action == null) {
            throw new IllegalArgumentException("The action cannot be null");
        }
        if (window == null) {
            throw new IllegalArgumentException("The window cannot be null");
        }
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                action.actionPerformed(null);
            }
        });
    }

    public static void showOnlyCloseDecoration(JFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("The JFrame cannot be null");
        }
        frame.getRootPane().setWindowDecorationStyle(2);
        frame.setResizable(false);
    }

    public static void hideDecoration(JFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("The JFrame cannot be null");
        }
        frame.getRootPane().setWindowDecorationStyle(0);
    }

    public static void hideDecoration(JDialog frame) {
        if (frame == null) {
            throw new IllegalArgumentException("The JDialog cannot be null");
        }
        frame.getRootPane().setWindowDecorationStyle(0);
    }

    public static void setFullScreenWindow(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("The window cannot be null");
        }
        window.setSize(Toolkit.getDefaultToolkit().getScreenSize());
    }

    public static boolean setOpacity(Window w, float alpha) {
        if (w instanceof JFrame) {
            ((JFrame)w).setUndecorated(true);
            WindowsUtils.hideDecoration((JFrame)w);
        } else if (w instanceof JDialog) {
            ((JDialog)w).setUndecorated(true);
            WindowsUtils.hideDecoration((JDialog)w);
        }
        try {
            Class<?> c = w.getClass();
            Method m = c.getMethod("setOpacity", Float.TYPE);
            if (m != null) {
                m.invoke((Object)w, Float.valueOf(alpha));
            } else {
                c = Class.forName("com.sun.awt.AWTUtilities");
                m = c.getMethod("setWindowOpacity", Window.class, Float.TYPE);
                m.invoke(null, w, Float.valueOf(alpha));
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Unable to set opacity.");
            return false;
        }
    }

    public static boolean setShape(Window w, Shape shape) {
        try {
            Class<?> c = Class.forName("com.sun.awt.AWTUtilities");
            Method m = c.getMethod("setWindowShape", Window.class, Shape.class);
            m.invoke(null, w, shape);
            return true;
        }
        catch (ClassNotFoundException e) {
            System.out.println("java 6 U 10 + not available");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }
}

