/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.application;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.DefaultWindowManager;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.gui.UIUtil;

public class GENEEWindowMenu
extends JMenu
implements ActionListener,
MenuListener {
    public GENEEWindowMenu() {
        super("Window");
        this.addMenuListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src instanceof WindowMenuItem) {
            WindowMenuItem item = (WindowMenuItem)src;
            GENEEWindow window = Application.getWindowManager().getWindow(item.key);
            window.activate();
        } else if (src instanceof DocumentMenuItem) {
            DocumentMenuItem item = (DocumentMenuItem)src;
            Application.getWindowManager().open(item.node);
        }
    }

    @Override
    public void menuCanceled(MenuEvent event) {
    }

    @Override
    public void menuDeselected(MenuEvent event) {
    }

    @Override
    public void menuSelected(MenuEvent event) {
        this.rebuild();
    }

    public void rebuild() {
        Component[] menuComponents = this.getMenuComponents();
        int count = menuComponents.length;
        for (int i = 0; i < count; ++i) {
            if (menuComponents[i] instanceof JMenuItem) {
                ((JMenuItem)menuComponents[i]).removeActionListener(this);
            }
            this.remove(menuComponents[i]);
        }
        ArrayList<WindowMenuItem> toolWindows = new ArrayList<WindowMenuItem>();
        int windowCount = 1;
        for (String key : Application.getWindowManager().getOpenedWindowKeys(null)) {
            GENEEWindow window = Application.getWindowManager().getWindow(key);
            if (window == null) continue;
            String title = window.getTitle();
            WindowMenuItem newItem = new WindowMenuItem(key, title, this);
            boolean isTool = false;
            boolean isPrimary = false;
            boolean isSecondary = false;
            if (window instanceof DefaultWindowManager.WMWindow) {
                int type = ((DefaultWindowManager.WMWindow)window).getWindowType();
                isTool = 3 == type;
                isPrimary = 0 == type;
                boolean bl = isSecondary = 1 == type;
            }
            if (isPrimary && windowCount < 10) {
                newItem.setAccelerator(KeyStroke.getKeyStroke(48 + windowCount, UIUtil.getMenuShortcutKeyMask()));
                ++windowCount;
            }
            if (isSecondary || isPrimary) {
                this.add(newItem);
                continue;
            }
            if (!isTool) continue;
            toolWindows.add(newItem);
        }
        if (this.getMenuComponentCount() > 0) {
            this.addSeparator();
        }
        for (WindowMenuItem mi : toolWindows) {
            this.add(mi);
        }
        this.revalidate();
        this.repaint();
    }

    private static class WindowMenuItem
    extends JMenuItem {
        private String key;

        private WindowMenuItem(String key, String title, ActionListener listener) {
            super(title);
            this.addActionListener(listener);
            this.key = key;
        }
    }

    private static class DocumentMenuItem
    extends JCheckBoxMenuItem {
        private ProjectGENEEResultTreeNode node;

        private DocumentMenuItem(ProjectGENEEResultTreeNode doc, ActionListener listener) {
            super(doc.toString(), false);
            this.addActionListener(listener);
            this.node = doc;
        }
    }
}

