/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.application;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.broadinstitute.genee.application.HistoryParameter;

public class History
implements Serializable {
    private static final long serialVersionUID = -801371265473146017L;
    private String operationName;
    private List<HistoryParameter> parameters = new ArrayList<HistoryParameter>();
    private String date;

    public History() {
    }

    public History(History history) {
        this.date = history.date;
        this.operationName = history.operationName;
        this.parameters = new ArrayList<HistoryParameter>(history.parameters);
    }

    public History(String operationName) {
        if (operationName != null && operationName.endsWith("\u2026")) {
            operationName = operationName.substring(0, operationName.length() - "\u2026".length());
        }
        this.operationName = operationName;
        this.date = DateFormat.getInstance().format(new Date());
    }

    public void add(String name, String value) {
        this.parameters.add(new HistoryParameter(name, value));
    }

    public String getDate() {
        return this.date;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public List<HistoryParameter> getParameters() {
        return this.parameters;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public void setParameters(List<HistoryParameter> parameters) {
        this.parameters = parameters;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<html>");
        int n = this.parameters.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buf.append("<br>");
            }
            HistoryParameter p = this.parameters.get(i);
            buf.append(p.getKey());
            buf.append(" ");
            buf.append(p.getValue());
        }
        return buf.toString();
    }
}

