/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.application;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;

public class SplashWindow
extends Window {
    private static SplashWindow instance;
    private Image image;
    private boolean paintCalled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SplashWindow(Frame parent, Image image) {
        super(parent);
        this.image = image;
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(image, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (mt.isErrorID(0)) {
            this.setSize(0, 0);
            System.err.println("Warning: SplashWindow couldn't load splash image.");
            SplashWindow ie = this;
            synchronized (ie) {
                this.paintCalled = true;
                this.notifyAll();
            }
            return;
        }
        int imgWidth = image.getWidth(this);
        int imgHeight = image.getHeight(this);
        this.setSize(imgWidth, imgHeight);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenDim.width - imgWidth) / 2, (screenDim.height - imgHeight) / 2);
        MouseAdapter disposeOnClick = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent evt) {
                SplashWindow splashWindow = SplashWindow.this;
                synchronized (splashWindow) {
                    SplashWindow.this.paintCalled = true;
                    SplashWindow.this.notifyAll();
                }
                SplashWindow.this.dispose();
            }
        };
        this.addMouseListener(disposeOnClick);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        g.drawImage(this.image, 0, 0, this);
        if (!this.paintCalled) {
            this.paintCalled = true;
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splash(Image image) {
        if (instance == null && image != null) {
            Frame f = new Frame();
            instance = new SplashWindow(f, image);
            instance.show();
            if (!EventQueue.isDispatchThread() && Runtime.getRuntime().availableProcessors() == 1) {
                SplashWindow splashWindow = instance;
                synchronized (splashWindow) {
                    while (!SplashWindow.instance.paintCalled) {
                        try {
                            instance.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }

    public static void splash(URL imageURL) {
        if (imageURL != null) {
            SplashWindow.splash(Toolkit.getDefaultToolkit().createImage(imageURL));
        }
    }

    public static void disposeSplash() {
        if (instance != null) {
            instance.getOwner().dispose();
            instance = null;
        }
    }

    public static void startup(String className, String[] args) {
        try {
            Class.forName(className).getMethod("startup", String[].class).invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            InternalError error = new InternalError("Failed to invoke main method");
            error.initCause(e);
            throw error;
        }
    }
}

