/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.category;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.gui.ColorByIcon;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class CategoryLegend
extends JPanel {
    private MetadataModel metadata;
    private VectorColorModel colorModel;
    private boolean rows;
    private int boxSize;

    public CategoryLegend(boolean rows, int boxSize) {
        this.rows = rows;
        this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        this.setBackground(Color.WHITE);
        this.boxSize = boxSize;
    }

    public void setProject(Project project) {
        if (project != null) {
            this.colorModel = this.rows ? project.getRowColorModel() : project.getColumnColorModel();
            this.metadata = MetadataUtil.getCategoryColumns(this.rows ? project.getOriginalDataset().getRowMetadata() : project.getOriginalDataset().getColumnMetadata());
            this._update();
        }
    }

    private void _update() {
        if (this.colorModel == null) {
            return;
        }
        FormLayout fl = new FormLayout(UIUtil.rep("p:g", 2, ", 6px, "));
        this.setLayout((LayoutManager)fl);
        CellConstraints cc = new CellConstraints();
        for (int i = 0; i < this.metadata.getMetadataCount(); ++i) {
            Vector metadataColumn = this.metadata.get(i);
            Set possibleValues = VectorUtil.getValues(metadataColumn);
            if (metadataColumn.getName() != null) {
                JLabel label = new JLabel(metadataColumn.getName());
                label.setFont(label.getFont().deriveFont((float)(this.boxSize + 1)));
                fl.appendRow(UIUtil.decodeRowSpec("p:g"));
                this.add((Component)label, cc.xyw(1, fl.getRowCount(), fl.getColumnCount()));
            }
            int column = 1;
            for (Object value : possibleValues) {
                String text = Formatter.toString(value);
                Color color = (Color)this.colorModel.getMappedValue(metadataColumn, value);
                JLabel label = new JLabel(text);
                label.setFont(label.getFont().deriveFont((float)this.boxSize));
                label.setIcon(new ColorByIcon((Paint)color, this.boxSize));
                if (column == 1) {
                    fl.appendRow(UIUtil.decodeRowSpec("p:g"));
                }
                this.add((Component)label, cc.xy(column, fl.getRowCount()));
                if ((column += 2) <= 3) continue;
                column = 1;
            }
        }
        this.revalidate();
        this.repaint();
    }
}

