/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.category;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import org.broadinstitute.genee.category.ColorPanel;
import org.broadinstitute.genee.category.ColumnCategoryNamesPanel;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DefaultSizesAndPositions;
import org.broadinstitute.genee.heatmap.HeatMapElementPanel;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;

public class ColumnCategoryPanel
extends ColorPanel {
    private ProjectListener projectListener = new ProjectListener(){

        @Override
        public void projectChanged(ProjectEvent e) {
            boolean vis;
            ColumnCategoryPanel.this.dataset = ColumnCategoryPanel.this.project.getSortedFilteredDataset();
            ColumnCategoryPanel.this.metadata = MetadataUtil.getCategoryColumns(ColumnCategoryPanel.this.dataset.getColumnMetadata());
            boolean bl = vis = ColumnCategoryPanel.this.metadata.getMetadataCount() > 0;
            if (ColumnCategoryPanel.this.isVisible() != vis) {
                ColumnCategoryPanel.this.setVisible(vis);
            } else {
                ColumnCategoryPanel.this.revalidate();
                ColumnCategoryPanel.this.repaint();
            }
        }
    };
    private Project project;
    private Dataset dataset;
    private MetadataModel metadata;

    public ColumnCategoryPanel(final ColumnCategoryNamesPanel columnCategoryNamesPanel) {
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (ColumnCategoryPanel.this.dataset == null) {
                    return;
                }
                if (ColumnCategoryPanel.this.metadata.getMetadataCount() > 0) {
                    int catIdx = ColumnCategoryPanel.this.getMetadataIndex(e);
                    columnCategoryNamesPanel.setBoldedMetadataIndex(catIdx);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                columnCategoryNamesPanel.setBoldedMetadataIndex(-1);
            }
        });
    }

    public void setProject(Project project) {
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
        this.project = project;
        if (this.project != null) {
            this.project.addProjectListener(this.projectListener);
            this.projectListener.projectChanged(null);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        UIUtil.registerToolTip(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        UIUtil.unregisterToolTip(this);
    }

    @Override
    public void draw(Graphics g, Rectangle clip) {
        if (this.dataset == null) {
            return;
        }
        int left = HeatMapElementPanel.getLeft(clip, this.sizesAndPositions);
        int right = HeatMapElementPanel.getRight(this.dataset.getColumnCount(), clip, this.sizesAndPositions);
        this.drawByColumn(g, left, right);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = new Dimension();
        preferredSize.width = this.sizesAndPositions != null ? HeatMapPanel.getSize(this.sizesAndPositions) : 0;
        preferredSize.height = this.metadata != null ? this.metadata.getMetadataCount() * this.categorySize + 2 : 0;
        return preferredSize;
    }

    @Override
    public Dimension getDrawableSize() {
        Dimension d = new Dimension(this.getPreferredSize());
        d.height += 4;
        return d;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int[] columnIndices = DefaultSizesAndPositions.getIndices(this.sizesAndPositions, e.getPoint().x);
        StringBuilder buf = new StringBuilder();
        buf.append("<html>");
        int metadataIndex = this.getMetadataIndex(e);
        String columnMetadataName = this.metadata.get(metadataIndex).getName();
        for (int index : columnIndices) {
            buf.append(DatasetUtil.getToolTipText(this.dataset, -1, index, null, columnMetadataName));
            buf.append("<br>");
        }
        return buf.toString();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.metadata.getMetadataCount() == 0) {
            return;
        }
        Rectangle rect = this.getVisibleRect();
        int left = HeatMapElementPanel.getLeft(rect, this.sizesAndPositions);
        int right = HeatMapElementPanel.getRight(this.dataset.getColumnCount(), rect, this.sizesAndPositions);
        this.drawByColumn(g, left, right);
    }

    private void drawByColumn(Graphics g, int left, int right) {
        int yStart;
        boolean alignToBottom = false;
        Rectangle2D.Float rect = new Rectangle2D.Float();
        int y = yStart = (alignToBottom ? this.getHeight() : this.getPreferredSize().height) - 1 - this.categorySize;
        Graphics2D g2 = (Graphics2D)g;
        int categoryGroupsSize = this.metadata.getMetadataCount();
        for (int metadataColumnIndex = 0; metadataColumnIndex < categoryGroupsSize; ++metadataColumnIndex) {
            Vector column = this.metadata.get(metadataColumnIndex);
            for (int col = left; col < right; ++col) {
                Color c;
                Object value = column.getValue(col);
                float xpix = this.sizesAndPositions.getPosition(col);
                float pixWidth = this.sizesAndPositions.getSize();
                if (value != null && (c = (Color)this.categoryColorModel.getMappedValue(column, value)) != null) {
                    g.setColor(c);
                    rect.setRect(xpix, y, pixWidth, this.categorySize);
                    g2.fill(rect);
                }
                if (!this.gridVisible || !(pixWidth > 3.0f) || this.categorySize <= 3) continue;
                g.setColor(Color.GRAY);
                rect.setRect(xpix, y, pixWidth, this.categorySize);
                g2.draw(rect);
            }
            y -= this.categorySize;
        }
    }

    private int getMetadataIndex(MouseEvent e) {
        int categoryGroupIndex = (int)Math.ceil(e.getPoint().y / this.categorySize);
        categoryGroupIndex = this.metadata.getMetadataCount() - categoryGroupIndex - 1;
        categoryGroupIndex = Math.max(categoryGroupIndex, 0);
        categoryGroupIndex = Math.min(categoryGroupIndex, this.metadata.getMetadataCount() - 1);
        return categoryGroupIndex;
    }
}

