/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.category;

import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.genee.category.AbstractVectorVisualMapper;
import org.broadinstitute.genee.category.QualitativeColorSchemes;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.category.VectorVisualMapperEvent;
import org.broadinstitute.genee.heatmap.DefaultHeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class DefaultVectorColorModel
extends AbstractVectorVisualMapper<Color>
implements VectorColorModel {
    private int colorIndex;
    private HashMap<String, Map<Object, Color>> vectorNameToColorMap = new LinkedHashMap<String, Map<Object, Color>>();
    private HashMap<String, HeatMapColorScheme> vectorNameToColorScheme = new HashMap();
    public static final Color[] DEFAULT_CONTINUOUS_COLORS = new Color[]{Color.BLUE, Color.WHITE, Color.RED};

    public void clear(Vector vector) {
        this.vectorNameToColorMap.remove(vector.getName());
        this.vectorNameToColorScheme.remove(vector.getName());
    }

    @Override
    public boolean containsDiscreteColor(Vector vector, Object value) {
        Map<Object, Color> metadataValueToColorMap = this.vectorNameToColorMap.get(vector.getName());
        if (metadataValueToColorMap == null) {
            return false;
        }
        Color c = metadataValueToColorMap.get(value);
        return c != null;
    }

    @Override
    public Color getMappedValue(Vector vector, Object value) {
        Color color;
        if (vector instanceof Vector && !MetadataUtil.getBoolean(vector, "Discrete Key")) {
            HeatMapColorScheme cs = this.vectorNameToColorScheme.get(vector.getName());
            if (cs == null) {
                cs = this.createContinuousColorMap(vector);
            }
            return cs.getColor(0, 0, ((Number)value).floatValue());
        }
        Map<Object, Color> metadataValueToColorMap = this.vectorNameToColorMap.get(vector.getName());
        if (metadataValueToColorMap == null) {
            metadataValueToColorMap = new HashMap<Object, Color>();
            this.vectorNameToColorMap.put(vector.getName(), metadataValueToColorMap);
        }
        if ((color = metadataValueToColorMap.get(value)) == null) {
            if (this.vectorNameToColorMap.size() > 0) {
                for (Map<Object, Color> existingMetadataValueToColorMap : this.vectorNameToColorMap.values()) {
                    color = existingMetadataValueToColorMap.get(value);
                    if (color == null) continue;
                    metadataValueToColorMap.put(value, color);
                    break;
                }
            }
            if (color == null) {
                if ("NA".equals(value) || "na".equals(value)) {
                    color = Color.LIGHT_GRAY;
                } else if ("".equals(value) || "WT".equals(value) || "wt".equals(value)) {
                    color = Color.WHITE;
                } else {
                    color = QualitativeColorSchemes.TWENTY_COLORS[this.colorIndex % QualitativeColorSchemes.TWENTY_COLORS.length];
                    metadataValueToColorMap.put(value, color);
                }
                ++this.colorIndex;
            }
        }
        return color;
    }

    @Override
    public HeatMapColorScheme getContinuousColorScheme(Vector vector) {
        HeatMapColorScheme cs = this.vectorNameToColorScheme.get(vector.getName());
        if (cs == null) {
            cs = this.createContinuousColorMap(vector);
        }
        return cs;
    }

    @Override
    public void setMappedValue(Vector vector, Object value, Color color) {
        Map<Object, Color> map = this.vectorNameToColorMap.get(vector.getName());
        if (map == null) {
            map = new HashMap<Object, Color>();
            this.vectorNameToColorMap.put(vector.getName(), map);
        }
        map.put(value, color);
        this.fireVectorVisualMapperListenerChanged(new VectorVisualMapperEvent(this));
    }

    private HeatMapColorScheme createContinuousColorMap(Vector vector) {
        DefaultHeatMapColorScheme cs = new DefaultHeatMapColorScheme();
        cs.setColors(DEFAULT_CONTINUOUS_COLORS);
        this.vectorNameToColorScheme.put(vector.getName(), cs);
        float min = VectorUtil.getMin(vector);
        float max = VectorUtil.getMax(vector);
        if (min < 0.0f && max > 0.0f) {
            float span = max - min;
            float zeroFraction = (0.0f - min) / span;
            if (Float.isInfinite(span)) {
                zeroFraction = 1.0E-5f;
            }
            cs.setColors(DEFAULT_CONTINUOUS_COLORS, new float[]{0.0f, zeroFraction, 1.0f});
        }
        cs.setGlobalMinMode(2, min);
        cs.setGlobalMaxMode(2, max);
        return cs;
    }

    public static DefaultVectorColorModel copy(MetadataModel metadata, VectorColorModel categoryColorModel) {
        DefaultVectorColorModel defaultCategoryColorModel = new DefaultVectorColorModel();
        int size = metadata.getMetadataCount();
        for (int i = 0; i < size; ++i) {
            String columnName = metadata.getColumnName(i);
            if (!MetadataUtil.getBoolean(metadata.get(i), "Discrete Key")) {
                HeatMapColorScheme continousColors = categoryColorModel.getContinuousColorScheme(metadata.get(i));
                if (continousColors == null) continue;
                defaultCategoryColorModel.vectorNameToColorScheme.put(columnName, DefaultHeatMapColorScheme.copy(continousColors));
                continue;
            }
            Set possibleValues = VectorUtil.getValues(metadata.get(metadata.getColumnIndex(columnName)));
            for (Object category : possibleValues) {
                Color color = (Color)categoryColorModel.getMappedValue(metadata.get(i), category);
                Map<Object, Color> map = defaultCategoryColorModel.vectorNameToColorMap.get(columnName);
                if (map == null) {
                    map = new HashMap<Object, Color>();
                    defaultCategoryColorModel.vectorNameToColorMap.put(columnName, map);
                }
                map.put(category, color);
            }
        }
        return defaultCategoryColorModel;
    }
}

