/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.broadinstitute.genee.chart.AbstractChartRenderer;
import org.broadinstitute.genee.chart.BoxPlotChartDataset;
import org.broadinstitute.genee.chart.BoxPlotToolTipProvider;
import org.broadinstitute.genee.chart.GENEEChart;
import org.broadinstitute.genee.chart.ShapeUtil;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.chart.grid.ChartUtil;
import org.broadinstitute.genee.heatmap.CoordinateMapper;
import org.broadinstitute.genee.matrix.FloatList;

public class BoxPlotChartRenderer
extends AbstractChartRenderer {
    public static final String MEAN = "mean";
    public static final String MEDIAN = "median";
    public static final String OUTLIERS = "outliers";
    public static final String QUANTILES = "quantiles";
    public static final String STANDARD_DEVIATION = "standard.deviation";
    private boolean meanVisible = true;
    private boolean medianVisible = true;
    private boolean outliersVisible = true;
    private boolean quantilesVisible = true;
    private boolean standardDeviationVisible = true;

    public BoxPlotChartRenderer() {
        this.setChartToolTipProvider(new BoxPlotToolTipProvider());
    }

    @Override
    public int getItemIndex(GENEEChart chart, CoordinateMapper chartCoordinateMapper, XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int xpix, int ypix) {
        return ChartUtil.findSortedBarItemIndex(this.chartPropertiesSupplier, chartCoordinateMapper, chartDataset, datasetIndex, seriesIndex, xpix, ypix);
    }

    @Override
    public void paint(XYChartDataset chartDataset, int datasetIndex, Graphics2D g2, CoordinateMapper worldCoordinateMapper) {
        int count = chartDataset.getSeriesCount();
        for (int seriesIndex = 0; seriesIndex < count; ++seriesIndex) {
            this.paintBoxPlotVertical(g2, worldCoordinateMapper, (BoxPlotChartDataset)chartDataset, datasetIndex, seriesIndex);
        }
    }

    public void setProperty(String property, boolean visible) {
        if (MEAN.equals(property)) {
            this.meanVisible = visible;
        } else if (MEDIAN.equals(property)) {
            this.medianVisible = visible;
        } else if (OUTLIERS.equals(property)) {
            this.outliersVisible = visible;
        } else if (QUANTILES.equals(property)) {
            this.quantilesVisible = visible;
        } else if (STANDARD_DEVIATION.equals(property)) {
            this.standardDeviationVisible = visible;
        }
    }

    private void drawOutliers(Graphics2D g2, CoordinateMapper worldCoordinateMapper, FloatList list, float xpix) {
        int pointSize = 6;
        Shape shape = ShapeUtil.getShape(0, pointSize);
        int npoints = list.size();
        for (int i = 0; i < npoints; ++i) {
            float ypix = worldCoordinateMapper.yToPix(list.getValue(i));
            AffineTransform transform = AffineTransform.getTranslateInstance(xpix - (float)(pointSize / 2), ypix - (float)(pointSize / 2));
            g2.draw(transform.createTransformedShape(shape));
        }
    }

    private void paintBoxPlotVertical(Graphics2D g2, CoordinateMapper worldCoordinateMapper, BoxPlotChartDataset chartDataset, int datasetIndex, int seriesIndex) {
        int size = chartDataset.getItemCount(seriesIndex);
        for (int itemIndex = 0; itemIndex < size; ++itemIndex) {
            Color itemColor = this.chartPropertiesSupplier.getItemColor(chartDataset, datasetIndex, seriesIndex, itemIndex);
            g2.setColor(itemColor);
            float barWidth = worldCoordinateMapper.getXPixPerUnit() * 0.8f;
            if (barWidth > 60.0f) {
                barWidth = 60.0f;
            }
            float xPix = worldCoordinateMapper.xToPix(itemIndex);
            float xPixStart = xPix - barWidth / 2.0f;
            float xPixEnd = xPix + barWidth / 2.0f;
            float horizontalLineLength = barWidth / 4.0f;
            Stroke stroke = g2.getStroke();
            if (this.quantilesVisible) {
                float q1 = chartDataset.getQ1(seriesIndex, itemIndex);
                float q1Pix = worldCoordinateMapper.yToPix(q1);
                float q3Pix = worldCoordinateMapper.yToPix(chartDataset.getQ3(seriesIndex, itemIndex));
                Rectangle2D.Float rect = new Rectangle2D.Float(xPixStart, Math.min(q1Pix, q3Pix), xPixEnd - xPixStart, Math.abs(q1Pix - q3Pix));
                g2.draw(rect);
                g2.setStroke(new BasicStroke(1.0f, 2, 2, 1.0f, new float[]{4.0f}, 0.0f));
                Line2D.Float line = new Line2D.Float();
                float uavPix = worldCoordinateMapper.yToPix(chartDataset.getUpperAdjacentValue(seriesIndex, itemIndex));
                line.setLine(xPix, uavPix, xPix, q3Pix);
                g2.draw(line);
                float lav = chartDataset.getLowerAdjacentValue(seriesIndex, itemIndex);
                float lavPix = worldCoordinateMapper.yToPix(lav);
                line.setLine(xPix, q1Pix, xPix, lavPix);
                g2.draw(line);
                g2.setStroke(stroke);
                line.setLine(xPix - horizontalLineLength, lavPix, xPix + horizontalLineLength, lavPix);
                g2.draw(line);
                line.setLine(xPix - horizontalLineLength, uavPix, xPix + horizontalLineLength, uavPix);
                g2.draw(line);
            }
            float stdevxpix = xPixEnd - 4.0f;
            float meanPix = worldCoordinateMapper.yToPix(chartDataset.getMean(seriesIndex, itemIndex));
            if (this.meanVisible) {
                float pointSize = 10.0f;
                Shape meanShape = ShapeUtil.createDiamond(pointSize);
                AffineTransform transform = AffineTransform.getTranslateInstance(stdevxpix - pointSize / 2.0f, meanPix - pointSize / 2.0f);
                g2.fill(transform.createTransformedShape(meanShape));
            }
            if (this.standardDeviationVisible) {
                BasicStroke dashedStroke = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{4.0f}, 0.0f);
                g2.setStroke(dashedStroke);
                Line2D.Float line = new Line2D.Float();
                float ytop = worldCoordinateMapper.yToPix(chartDataset.getMean(seriesIndex, itemIndex) + chartDataset.getStandardDeviation(seriesIndex, itemIndex));
                line.setLine(stdevxpix, meanPix, stdevxpix, ytop);
                g2.draw(line);
                g2.setStroke(stroke);
                line.setLine(stdevxpix - horizontalLineLength, ytop, stdevxpix + horizontalLineLength, ytop);
                g2.draw(line);
                float ybottom = worldCoordinateMapper.yToPix(chartDataset.getMean(seriesIndex, itemIndex) - chartDataset.getStandardDeviation(seriesIndex, itemIndex));
                line.setLine(stdevxpix, meanPix, stdevxpix, ybottom);
                g2.setStroke(dashedStroke);
                g2.draw(line);
                g2.setStroke(stroke);
                line.setLine(stdevxpix - horizontalLineLength, ybottom, stdevxpix + horizontalLineLength, ybottom);
                g2.draw(line);
            }
            if (this.medianVisible) {
                Rectangle2D.Float rect = new Rectangle2D.Float();
                float medianPix = worldCoordinateMapper.yToPix(chartDataset.getMedian(seriesIndex, itemIndex));
                rect.setRect(xPixStart, medianPix, xPixEnd - xPixStart, 2.0f);
                g2.fill(rect);
            }
            if (!this.outliersVisible) continue;
            this.drawOutliers(g2, worldCoordinateMapper, chartDataset.getUpperOutliers(seriesIndex, itemIndex), xPix);
            this.drawOutliers(g2, worldCoordinateMapper, chartDataset.getLowerOutliers(seriesIndex, itemIndex), xPix);
        }
    }
}

