/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import org.broadinstitute.genee.chart.BoxPlotChartDataset;
import org.broadinstitute.genee.chart.ChartToolTipProvider;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.io.util.Formatter;

public class BoxPlotToolTipProvider
implements ChartToolTipProvider {
    @Override
    public String getToolTipText(XYChartDataset chartDataset, int seriesIndex, int itemIndex) {
        StringBuilder buf = new StringBuilder();
        BoxPlotChartDataset dataset = (BoxPlotChartDataset)chartDataset;
        buf.append("<table>");
        buf.append("<tr><td>UAV:<td>");
        buf.append(Formatter.format(dataset.getUpperAdjacentValue(seriesIndex, itemIndex)));
        buf.append("<tr><td>Q3:<td>");
        buf.append(Formatter.format(dataset.getQ3(seriesIndex, itemIndex)));
        buf.append("<tr><td>Median:<td>");
        buf.append(Formatter.format(dataset.getMedian(seriesIndex, itemIndex)));
        buf.append("<tr><td>Mean:<td>");
        buf.append(Formatter.format(dataset.getMean(seriesIndex, itemIndex)));
        buf.append("<tr><td>Q1:<td>");
        buf.append(Formatter.format(dataset.getQ1(seriesIndex, itemIndex)));
        buf.append("<tr><td>LAV:<td>");
        buf.append(Formatter.format(dataset.getLowerAdjacentValue(seriesIndex, itemIndex)));
        buf.append("<tr><td>Min:<td>");
        buf.append(Formatter.format(dataset.getMin(seriesIndex, itemIndex)));
        buf.append("<tr><td>Max:<td>");
        buf.append(Formatter.format(dataset.getMax(seriesIndex, itemIndex)));
        buf.append("<tr><td># of outliers:<td>");
        int noutliers = dataset.getUpperOutliers(seriesIndex, itemIndex).size() + dataset.getLowerOutliers(seriesIndex, itemIndex).size();
        buf.append(noutliers);
        return buf.toString();
    }
}

