/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.broadinstitute.genee.gui.ButtonGroupHelper;
import org.broadinstitute.genee.gui.EditColorButton;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.CurveElementPainter;
import org.broadinstitute.genee.heatmap.DefaultElementPainter;
import org.broadinstitute.genee.heatmap.ElementPainter;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ParserHelper;

public class CurveOptionsPanel
extends JPanel {
    private HeatMapPanel heatMapPanel;
    private EditColorButton backgroundColorButton;
    private JCheckBox drawCurvesCheckBox;
    private JCheckBox drawPoints;
    private JCheckBox drawIC50CheckBox;
    private JCheckBox drawFitCheckBox;
    private Scaling yScaling;
    private Scaling xScaling;
    private JCheckBox fillCurvesCheckBox;
    private JCheckBox drawErrorBars;

    public CurveOptionsPanel(final HeatMapPanel heatMapPanel) {
        this.heatMapPanel = heatMapPanel;
        ElementPainter painter = heatMapPanel.getElementPainter();
        FormBuilder formBuilder = new FormBuilder(this);
        formBuilder.nextRow();
        this.drawCurvesCheckBox = new JCheckBox("Draw curves in heat map", painter instanceof CurveElementPainter);
        formBuilder.addFirstColumn(this.drawCurvesCheckBox);
        formBuilder.nextRow();
        this.drawPoints = new JCheckBox("Draw points", painter instanceof CurveElementPainter && ((CurveElementPainter)painter).isDrawPoints());
        formBuilder.addFirstColumn(this.drawPoints);
        formBuilder.nextRow();
        this.drawErrorBars = new JCheckBox("Draw error bars", painter instanceof CurveElementPainter && ((CurveElementPainter)painter).isDrawErrorBars());
        formBuilder.addFirstColumn(this.drawErrorBars);
        formBuilder.nextRow();
        this.drawIC50CheckBox = new JCheckBox("Draw IC\u2085\u2080", painter instanceof CurveElementPainter && ((CurveElementPainter)painter).isDrawIC50());
        formBuilder.addFirstColumn(this.drawIC50CheckBox);
        formBuilder.nextRow();
        this.drawFitCheckBox = new JCheckBox("Draw Fit", painter instanceof CurveElementPainter && ((CurveElementPainter)painter).isDrawFit());
        formBuilder.addFirstColumn(this.drawFitCheckBox);
        formBuilder.nextRow();
        this.fillCurvesCheckBox = new JCheckBox("Fill Curves", painter instanceof CurveElementPainter && ((CurveElementPainter)painter).isFilled());
        formBuilder.addFirstColumn(this.fillCurvesCheckBox);
        formBuilder.nextRow();
        formBuilder.nextRow();
        formBuilder.addLabel("Background color:");
        Color backgroundColor = Color.WHITE;
        if (painter instanceof CurveElementPainter) {
            backgroundColor = ((CurveElementPainter)painter).getBackgroundColor();
        }
        this.backgroundColorButton = new EditColorButton(backgroundColor != null ? backgroundColor : Color.WHITE);
        formBuilder.add(this.backgroundColorButton);
        this.backgroundColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CurveElementPainter painter = (CurveElementPainter)heatMapPanel.getElementPainter();
                painter.setBackgroundColor(CurveOptionsPanel.this.backgroundColorButton.getColor());
                heatMapPanel.invalidateImage();
            }
        });
        this.backgroundColorButton.setEnabled(painter instanceof CurveElementPainter);
        this.xScaling = new Scaling(formBuilder, painter, heatMapPanel, true);
        this.yScaling = new Scaling(formBuilder, painter, heatMapPanel, false);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CurveOptionsPanel.this.updatePainter();
            }
        };
        this.drawCurvesCheckBox.addActionListener(listener);
        this.drawIC50CheckBox.addActionListener(listener);
        this.drawFitCheckBox.addActionListener(listener);
        this.fillCurvesCheckBox.addActionListener(listener);
        this.drawPoints.addActionListener(listener);
        this.drawErrorBars.addActionListener(listener);
        this.xScaling.addActionListener(listener);
        this.yScaling.addActionListener(listener);
    }

    private void updateComponents() {
        boolean drawCurves = this.drawCurvesCheckBox.isSelected();
        UIUtil.setChildrenEnabledRecursively(this, drawCurves);
        this.drawCurvesCheckBox.setEnabled(true);
        this.xScaling.setEnabled();
        this.yScaling.setEnabled();
        this.backgroundColorButton.setEnabled(this.heatMapPanel.getElementPainter() instanceof CurveElementPainter);
    }

    private void updatePainter() {
        if (!this.drawCurvesCheckBox.isSelected()) {
            this.heatMapPanel.getColorScheme().setGlobalMinMode(0);
            this.heatMapPanel.getColorScheme().setGlobalMaxMode(0);
            this.heatMapPanel.setElementPainter(new DefaultElementPainter());
        } else {
            CurveElementPainter painter = this.heatMapPanel.getElementPainter() instanceof CurveElementPainter ? (CurveElementPainter)this.heatMapPanel.getElementPainter() : new CurveElementPainter();
            painter.setDrawErrorBars(this.drawErrorBars.isSelected());
            painter.setDrawPoints(this.drawPoints.isSelected());
            painter.setXScalingMode(this.xScaling.getScalingMode());
            painter.setYScalingMode(this.yScaling.getScalingMode());
            painter.setBackgroundColor(this.backgroundColorButton.getColor());
            painter.setDrawFit(this.drawFitCheckBox.isSelected());
            painter.setDrawIC50(this.drawIC50CheckBox.isSelected());
            painter.setFilled(this.fillCurvesCheckBox.isSelected());
            this.heatMapPanel.setElementPainter(painter);
        }
        this.updateComponents();
    }

    private static class Scaling {
        private JRadioButton scaleColumnMinMax;
        private JRadioButton scaleGlobalMinMax;
        private AbstractButton scaleRowMinMax;
        private AbstractButton scaleElementMinMax;
        private JRadioButton customScaleButton;
        private TimerTextField customMinTextField;
        private TimerTextField customMaxTextField;

        private Scaling(FormBuilder formBuilder, ElementPainter painter, final HeatMapPanel heatMapPanel, final boolean xAxis) {
            int initialScaling = 1;
            if (painter instanceof CurveElementPainter) {
                CurveElementPainter p = (CurveElementPainter)painter;
                initialScaling = xAxis ? p.getXScalingMode() : p.getYScalingMode();
            }
            formBuilder.nextRow();
            formBuilder.addLabel((xAxis ? "X" : "Y") + " Scale:");
            ButtonGroupHelper scaleButtonGroup = new ButtonGroupHelper();
            this.scaleColumnMinMax = scaleButtonGroup.createRadioButton("Scale to column minimum and maximum", initialScaling == 0);
            this.scaleColumnMinMax.setEnabled(painter instanceof CurveElementPainter);
            this.scaleRowMinMax = scaleButtonGroup.createRadioButton("Scale to row minimum and maximum", initialScaling == 2);
            this.scaleRowMinMax.setEnabled(painter instanceof CurveElementPainter);
            this.scaleGlobalMinMax = scaleButtonGroup.createRadioButton("Scale to dataset minimum and maximum", initialScaling == 4);
            this.scaleGlobalMinMax.setEnabled(painter instanceof CurveElementPainter);
            this.scaleElementMinMax = scaleButtonGroup.createRadioButton("Scale each element individually", initialScaling == 1);
            this.scaleElementMinMax.setEnabled(painter instanceof CurveElementPainter);
            this.customScaleButton = scaleButtonGroup.createRadioButton("Custom", initialScaling == 3);
            this.customScaleButton.setEnabled(painter instanceof CurveElementPainter);
            formBuilder.add(this.scaleColumnMinMax);
            formBuilder.nextSmallRow();
            formBuilder.add(this.scaleRowMinMax);
            formBuilder.nextSmallRow();
            formBuilder.add(this.scaleGlobalMinMax);
            formBuilder.nextSmallRow();
            formBuilder.add(this.scaleElementMinMax);
            formBuilder.nextSmallRow();
            this.customMinTextField = new TimerTextField("0"){

                @Override
                public void update() {
                    float customMinValue = ParserHelper.parseFloat(this.getText().trim());
                    CurveElementPainter painter = (CurveElementPainter)heatMapPanel.getElementPainter();
                    if (xAxis) {
                        painter.setCustomXMin(customMinValue);
                    } else {
                        painter.setCustomYMin(customMinValue);
                    }
                    heatMapPanel.invalidateImage();
                }
            };
            this.customMinTextField.setEnabled(false);
            this.customMaxTextField = new TimerTextField("100"){

                @Override
                public void update() {
                    String value = this.getText();
                    if (value != null) {
                        float customMaxValue = ParserHelper.parseFloat(value.trim());
                        CurveElementPainter painter = (CurveElementPainter)heatMapPanel.getElementPainter();
                        if (xAxis) {
                            painter.setCustomXMax(customMaxValue);
                        } else {
                            painter.setCustomYMax(customMaxValue);
                        }
                        heatMapPanel.invalidateImage();
                    }
                }
            };
            this.customMaxTextField.setEnabled(false);
            formBuilder.add(this.customScaleButton);
            FormBuilder customForm = new FormBuilder();
            customForm.setIndentedBorder();
            customForm.nextRow();
            customForm.addLabel("Minimum:");
            customForm.add(this.customMinTextField);
            customForm.nextSmallRow();
            customForm.addLabel("Maximum:");
            customForm.add(this.customMaxTextField);
            formBuilder.nextSmallRow();
            formBuilder.add(customForm.getPanel());
        }

        public void addActionListener(ActionListener listener) {
            this.scaleColumnMinMax.addActionListener(listener);
            this.scaleRowMinMax.addActionListener(listener);
            this.scaleGlobalMinMax.addActionListener(listener);
            this.scaleElementMinMax.addActionListener(listener);
            this.customScaleButton.addActionListener(listener);
        }

        public void configure(int scalingMode, float min, float max) {
            this.scaleColumnMinMax.setSelected(scalingMode == 0);
            this.scaleRowMinMax.setSelected(scalingMode == 2);
            this.scaleGlobalMinMax.setSelected(scalingMode == 4);
            this.scaleElementMinMax.setSelected(scalingMode == 1);
            this.customScaleButton.setSelected(scalingMode == 3);
            if (!Float.isNaN(min)) {
                this.customMinTextField.setText(Formatter.format(min));
            }
            if (!Float.isNaN(max)) {
                this.customMaxTextField.setText(Formatter.format(max));
            }
        }

        public int getScalingMode() {
            int scaling;
            if (this.scaleColumnMinMax.isSelected()) {
                scaling = 0;
            } else if (this.scaleRowMinMax.isSelected()) {
                scaling = 2;
            } else if (this.scaleGlobalMinMax.isSelected()) {
                scaling = 4;
            } else if (this.customScaleButton.isSelected()) {
                scaling = 3;
            } else if (this.scaleElementMinMax.isSelected()) {
                scaling = 1;
            } else {
                throw new RuntimeException();
            }
            return scaling;
        }

        public void setEnabled() {
            this.customMinTextField.setEnabled(this.customScaleButton.isSelected());
            this.customMaxTextField.setEnabled(this.customScaleButton.isSelected());
        }
    }
}

