/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.chart.XYInterpolatedChartDataset;

public class DefaultXYInterpolatedChartDataset
implements XYInterpolatedChartDataset {
    protected XYChartDataset dest;
    protected float fraction;
    protected XYChartDataset source;

    public DefaultXYInterpolatedChartDataset() {
    }

    public DefaultXYInterpolatedChartDataset(XYChartDataset source, XYChartDataset dest) {
        this.source = source;
        this.dest = dest;
    }

    @Override
    public XYChartDataset getDestination() {
        return this.dest;
    }

    public float getFraction() {
        return this.fraction;
    }

    @Override
    public int getItemCount(int series) {
        return Math.max(series < this.source.getSeriesCount() ? this.source.getItemCount(series) : 0, series < this.dest.getSeriesCount() ? this.dest.getItemCount(series) : 0);
    }

    @Override
    public int getSeriesCount() {
        return this.source.getSeriesCount();
    }

    @Override
    public String getSeriesName(int series) {
        return series < this.dest.getSeriesCount() ? this.dest.getSeriesName(series) : "";
    }

    public XYChartDataset getSource() {
        return this.source;
    }

    @Override
    public float getX(int series, int index) {
        return this._getX(this.source, series, index) + this.fraction * (this._getX(this.dest, series, index) - this._getX(this.source, series, index));
    }

    @Override
    public float getXEnd(int series, int index) {
        return index < this.dest.getItemCount(series) ? this.dest.getXEnd(series, index) : 0.0f;
    }

    @Override
    public float getXMax() {
        return this.source.getXMax() + this.fraction * (this.dest.getXMax() - this.source.getXMax());
    }

    @Override
    public float getXMax(int series) {
        return this.source.getXMax(series) + this.fraction * (this.dest.getXMax(series) - this.source.getXMax(series));
    }

    @Override
    public float getXMin() {
        return this.source.getXMin() + this.fraction * (this.dest.getXMin() - this.source.getXMin());
    }

    @Override
    public float getXMin(int series) {
        return this.source.getXMin(series) + this.fraction * (this.dest.getXMin(series) - this.source.getXMin(series));
    }

    @Override
    public float getXStart(int series, int index) {
        return index < this.dest.getItemCount(series) ? this.dest.getXStart(series, index) : 0.0f;
    }

    @Override
    public float getY(int series, int index) {
        return this._getY(this.source, series, index) + this.fraction * (this._getY(this.dest, series, index) - this._getY(this.source, series, index));
    }

    @Override
    public float getYEnd(int series, int index) {
        return index < this.dest.getItemCount(series) ? this.dest.getYEnd(series, index) : 0.0f;
    }

    @Override
    public float getYMax() {
        return this.source.getYMax() + this.fraction * (this.dest.getYMax() - this.source.getYMax());
    }

    @Override
    public float getYMax(int series) {
        return this.source.getYMax(series) + this.fraction * (this.dest.getYMax(series) - this.source.getYMax(series));
    }

    @Override
    public float getYMin() {
        return this.source.getYMin() + this.fraction * (this.dest.getYMin() - this.source.getYMin());
    }

    @Override
    public float getYMin(int series) {
        return this.source.getYMin(series) + this.fraction * (this.dest.getYMin(series) - this.source.getYMin(series));
    }

    @Override
    public float getYStart(int series, int index) {
        return index < this.dest.getItemCount(series) ? this.dest.getYStart(series, index) : 0.0f;
    }

    @Override
    public void setDestination(XYChartDataset dest) {
        this.dest = dest;
    }

    @Override
    public void setFraction(float fraction) {
        this.fraction = fraction;
    }

    @Override
    public void setSource(XYChartDataset source) {
        this.source = source;
    }

    private float _getX(XYChartDataset d, int series, int index) {
        return series < d.getSeriesCount() && index < d.getItemCount(series) ? d.getX(series, index) : 0.0f;
    }

    private float _getY(XYChartDataset d, int series, int index) {
        return series < d.getSeriesCount() && index < d.getItemCount(series) ? d.getY(series, index) : 0.0f;
    }
}

