/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.awt.Color;
import java.awt.Graphics2D;
import org.broadinstitute.genee.chart.AbstractChartRenderer;
import org.broadinstitute.genee.chart.LineAndShapeRenderer;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.heatmap.CoordinateMapper;

public class DotPlotRenderer
extends AbstractChartRenderer {
    @Override
    public float getGutter() {
        return this.chartPropertiesSupplier.getGutter();
    }

    @Override
    public void paint(XYChartDataset chartDataset, int datasetIndex, Graphics2D g2, CoordinateMapper worldCoordinateMapper) {
        int nseries = chartDataset.getSeriesCount();
        for (int seriesIndex = 0; seriesIndex < nseries; ++seriesIndex) {
            this.paintPoints(g2, worldCoordinateMapper, chartDataset, datasetIndex, seriesIndex);
        }
    }

    private void paintPoints(Graphics2D g2, CoordinateMapper worldCoordinateMapper, XYChartDataset chartDataset, int datasetIndex, int seriesIndex) {
        int nitems = chartDataset.getItemCount(seriesIndex);
        for (int itemIndex = 0; itemIndex < nitems; ++itemIndex) {
            float y = chartDataset.getY(seriesIndex, itemIndex);
            float x = chartDataset.getX(seriesIndex, itemIndex);
            float xpix = worldCoordinateMapper.xToPix(x);
            float ypix = worldCoordinateMapper.yToPix(y);
            Color itemColor = this.chartPropertiesSupplier.getItemColor(chartDataset, datasetIndex, seriesIndex, itemIndex);
            g2.setColor(itemColor);
            LineAndShapeRenderer.paintSinglePoint(this.chartPropertiesSupplier, g2, xpix, ypix, chartDataset, datasetIndex, seriesIndex, itemIndex);
        }
    }
}

