/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.broadinstitute.genee.chart.ChartChangeEvent;
import org.broadinstitute.genee.chart.ChartChangeListener;
import org.broadinstitute.genee.chart.ChartOverlay;
import org.broadinstitute.genee.chart.ChartRenderer;
import org.broadinstitute.genee.chart.ChartSelectionEvent;
import org.broadinstitute.genee.chart.ChartSelectionListener;
import org.broadinstitute.genee.chart.ChartSelectionModel;
import org.broadinstitute.genee.chart.ChartToolTipProvider;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.CoordinateMapper;
import org.broadinstitute.genee.heatmap.WorldCoordinateMapper;

public class GENEEChart
extends JPanel {
    public static final int SELECTION_MODE_LINES_CLICK = 0;
    public static final int SELECTION_MODE_NONE = 3;
    public static final int SELECTION_MODE_POINTS_CLICK = 2;
    public static final int SELECTION_MODE_POINTS_DRAG = 1;
    private String backgroundText;
    private Color chartBackground;
    private CoordinateMapper chartCoordinateMapper;
    private ArrayList<XYChartDataset> chartDatasets = new ArrayList();
    private ChartRenderer chartRenderer;
    private ChartSelectionModel chartSelectionModel = new ChartSelectionModel();
    private float customXMax = Float.NaN;
    private float customXMin = Float.NaN;
    private float customYMax = Float.NaN;
    private float customYMin = Float.NaN;
    private Map<Integer, ChartRenderer> datasetIndexToChartRenderer = new HashMap<Integer, ChartRenderer>();
    private boolean drawTopAndRightGridLines = true;
    private MouseHandler mouseHandler;
    private String noDataMessage = "No data";
    private BufferedImage offscreenImage;
    private List<ChartOverlay> overlays = new ArrayList<ChartOverlay>();
    private int selectionMode = 3;
    private boolean validImage = false;

    public GENEEChart() {
        this((XYChartDataset)null);
    }

    public GENEEChart(XYChartDataset chartDataset) {
        this.setDoubleBuffered(false);
        this.setBackground(Color.WHITE);
        this.setFont(new Font(UIUtil.getFontName(), 0, 12));
        this.mouseHandler = new MouseHandler();
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
        this.chartCoordinateMapper = new WorldCoordinateMapper();
        if (chartDataset != null) {
            this.setChartDataset(chartDataset);
        }
        this.setMinimumSize(new Dimension());
    }

    public void addChartChangeListener(ChartChangeListener l) {
        this.listenerList.add(ChartChangeListener.class, l);
    }

    public void addChartDataset(XYChartDataset chartDataset) {
        if (chartDataset == null) {
            throw new NullPointerException();
        }
        this.chartDatasets.add(chartDataset);
    }

    public void addChartOverlay(ChartOverlay overlay) {
        this.overlays.add(overlay);
    }

    public void addChartSelectionListener(ChartSelectionListener l) {
        this.listenerList.add(ChartSelectionListener.class, l);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        UIUtil.registerToolTip(this);
    }

    public void clearChartDatasets() {
        this.chartDatasets.clear();
    }

    public void clearChartOverlays() {
        this.overlays.clear();
    }

    public void draw(Graphics2D g2, CoordinateMapper chartCoordinateMapper, int width, int height) {
        this.setScale(chartCoordinateMapper, width, height);
        g2.addRenderingHints(UIUtil.RENDERING_HINTS);
        String noDataMessage = null;
        if (this.chartDatasets.size() == 0) {
            if (this.noDataMessage != null) {
                noDataMessage = this.noDataMessage;
            }
        } else {
            boolean empty = true;
            for (XYChartDataset d : this.chartDatasets) {
                if (d.getSeriesCount() <= 0 || d.getItemCount(0) <= 0) continue;
                empty = false;
                break;
            }
            if (empty) {
                noDataMessage = this.noDataMessage;
            }
        }
        Stroke oldStroke = g2.getStroke();
        if (this.chartBackground != null) {
            g2.setColor(this.chartBackground);
            g2.fillRect(0, 0, (int)chartCoordinateMapper.getWidth(), (int)chartCoordinateMapper.getHeight());
        }
        if (this.drawTopAndRightGridLines) {
            g2.setColor(Color.LIGHT_GRAY);
            Line2D.Float line = new Line2D.Float();
            line.setLine(0.0f, 0.0f, chartCoordinateMapper.getWidth(), 0.0f);
            g2.draw(line);
            line.setLine(chartCoordinateMapper.getWidth() - 1.0f, 0.0f, chartCoordinateMapper.getWidth() - 1.0f, chartCoordinateMapper.getHeight());
            g2.draw(line);
        }
        if (this.chartDatasets.size() > 0) {
            Shape oldClip = g2.getClip();
            this.drawBackgroundText(g2, chartCoordinateMapper);
            int size = this.chartDatasets.size();
            for (int datasetIndex = 0; datasetIndex < size; ++datasetIndex) {
                ChartRenderer r = this.getChartRenderer(datasetIndex);
                r.paint(this.chartDatasets.get(datasetIndex), datasetIndex, g2, chartCoordinateMapper);
            }
            g2.setPaint(Color.BLACK);
            for (ChartOverlay overlay : this.overlays) {
                overlay.paint(g2, this, chartCoordinateMapper);
            }
            g2.setClip(oldClip);
        }
        g2.setStroke(oldStroke);
        g2.setColor(Color.BLACK);
        if (noDataMessage != null) {
            g2.drawString(noDataMessage, chartCoordinateMapper.getWidth() / 2.0f - (float)(g2.getFontMetrics().stringWidth(noDataMessage) / 2), chartCoordinateMapper.getHeight() / 2.0f);
        }
    }

    public void forceScale() {
        Dimension size = this.getPaintSize();
        int width = size.width;
        int height = size.height;
        this.setScale(this.chartCoordinateMapper, width, height);
    }

    public float getAutoscaleXMax() {
        float max = -3.4028235E38f;
        for (XYChartDataset d : this.chartDatasets) {
            float value = d.getXMax();
            if (Float.isNaN(value) || Float.isInfinite(value)) continue;
            max = value > max ? value : max;
        }
        return max;
    }

    public float getAutoscaleXMin() {
        float min = Float.MAX_VALUE;
        for (XYChartDataset d : this.chartDatasets) {
            float value = d.getXMin();
            if (Float.isNaN(value) || Float.isInfinite(value)) continue;
            min = value < min ? value : min;
        }
        return min;
    }

    public float getAutoscaleYMax() {
        float max = -3.4028235E38f;
        for (XYChartDataset d : this.chartDatasets) {
            float value = d.getYMax();
            if (Float.isNaN(value) || Float.isInfinite(value)) continue;
            max = value > max ? value : max;
        }
        return max;
    }

    public float getAutoscaleYMin() {
        float min = Float.MAX_VALUE;
        for (XYChartDataset d : this.chartDatasets) {
            float value = d.getYMin();
            if (Float.isNaN(value) || Float.isInfinite(value)) continue;
            min = value < min ? value : min;
        }
        return min;
    }

    public XYChartDataset getChartDataset() {
        return this.chartDatasets.size() > 0 ? this.chartDatasets.get(0) : null;
    }

    public List<XYChartDataset> getChartDatasets() {
        return (List)this.chartDatasets.clone();
    }

    public List<ChartOverlay> getChartOverlays() {
        return this.overlays;
    }

    public ChartRenderer getChartRenderer() {
        return this.chartRenderer;
    }

    public ChartRenderer getChartRenderer(int datasetIndex) {
        ChartRenderer r = this.datasetIndexToChartRenderer.get(datasetIndex);
        if (r == null) {
            r = this.chartRenderer;
        }
        return r;
    }

    public CoordinateMapper getCoordinateMapper() {
        return this.chartCoordinateMapper;
    }

    public float getCustomXMax() {
        return this.customXMax;
    }

    public float getCustomXMin() {
        return this.customXMin;
    }

    public float getCustomYMax() {
        return this.customYMax;
    }

    public float getCustomYMin() {
        return this.customYMin;
    }

    public Dimension getDrawableSize() {
        if (this.isShowing()) {
            return this.getSize();
        }
        return this.getPreferredSize();
    }

    public String getNoDataMessage() {
        return this.noDataMessage;
    }

    public Dimension getPaintSize() {
        if (this.isPreferredSizeSet()) {
            return this.getPreferredSize();
        }
        if (this.isShowing()) {
            Rectangle currentVisibleRect = this.getVisibleRect();
            return new Dimension(currentVisibleRect.width, currentVisibleRect.height);
        }
        return this.getSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return new Dimension();
    }

    public ChartSelectionModel getSelectionModel() {
        return this.chartSelectionModel;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Map<Integer, List<SeriesAndItem>> datasetToSeriesAndItems = this.getDatasetToSeriesAndItems(e);
        if (datasetToSeriesAndItems.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Integer datasetIndex : datasetToSeriesAndItems.keySet()) {
            List<SeriesAndItem> list = datasetToSeriesAndItems.get(datasetIndex);
            ChartRenderer renderer = this.getChartRenderer(datasetIndex);
            ChartToolTipProvider tip = renderer.getChartToolTipProvider();
            for (SeriesAndItem seriesAndItem : list) {
                if (sb.length() > 0) {
                    sb.append("<br>");
                }
                sb.append(tip.getToolTipText(this.chartDatasets.get(datasetIndex), seriesAndItem.series, seriesAndItem.item));
            }
        }
        return sb.toString();
    }

    public float getXMax() {
        if (!Float.isNaN(this.customXMax)) {
            return this.customXMax;
        }
        if (this.chartDatasets.size() == 0) {
            return 1.0f;
        }
        return this.getAutoscaleXMax();
    }

    public float getXMin() {
        if (!Float.isNaN(this.customXMin)) {
            return this.customXMin;
        }
        if (this.chartDatasets.size() == 0) {
            return 0.0f;
        }
        return this.getAutoscaleXMin();
    }

    public float getYMax() {
        if (!Float.isNaN(this.customYMax)) {
            return this.customYMax;
        }
        if (this.chartDatasets.size() == 0) {
            return 1.0f;
        }
        return this.getAutoscaleYMax();
    }

    public float getYMin() {
        if (!Float.isNaN(this.customYMin)) {
            return this.customYMin;
        }
        if (this.chartDatasets.size() == 0) {
            return 0.0f;
        }
        return this.getAutoscaleYMin();
    }

    public int interpolate(CoordinateMapper chartCoordinateMapper, XYChartDataset chartDataset, int seriesIndex, int lowerIndex, int upperIndex, float x, int ypix) {
        float x1;
        float y0 = chartDataset.getY(seriesIndex, lowerIndex);
        float y1 = chartDataset.getY(seriesIndex, upperIndex);
        float x0 = chartDataset.getX(seriesIndex, lowerIndex);
        float y = y0 + (x - x0) * (y1 - y0) / ((x1 = chartDataset.getX(seriesIndex, upperIndex)) - x0);
        float yMousePix = chartCoordinateMapper.yToPix(y);
        if (Math.abs(yMousePix - (float)ypix) < 5.0f) {
            return lowerIndex;
        }
        return -1;
    }

    public void invalidateImage() {
        this.validImage = false;
        this.repaint();
    }

    public float pixToX(int x) {
        return this.chartCoordinateMapper.pixToX(x);
    }

    public float pixToY(int y) {
        return this.chartCoordinateMapper.pixToY(y);
    }

    public void removeChartChangeListener(ChartChangeListener l) {
        this.listenerList.remove(ChartChangeListener.class, l);
    }

    public void removeChartDataset(XYChartDataset chartDataset) {
        this.chartDatasets.remove(chartDataset);
    }

    public void removeChartSelectionListener(ChartSelectionListener l) {
        this.listenerList.remove(ChartSelectionListener.class, l);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        UIUtil.unregisterToolTip(this);
    }

    public void setBackgroundText(String text) {
        this.backgroundText = text;
    }

    public void setChartBackground(Color color) {
        this.chartBackground = color;
    }

    public void setChartDataset(XYChartDataset chartDataset) {
        if (chartDataset == null) {
            throw new NullPointerException("chart dataset is null.");
        }
        this.chartDatasets.clear();
        this.chartDatasets.add(chartDataset);
        this.chartSelectionModel.clear();
        this.validImage = false;
    }

    public void setChartDatasets(List<? extends XYChartDataset> datasets) {
        this.chartDatasets.clear();
        if (datasets != null) {
            for (XYChartDataset xYChartDataset : datasets) {
                if (xYChartDataset == null) continue;
                this.chartDatasets.add(xYChartDataset);
            }
        }
    }

    public void setChartRenderer(ChartRenderer chartRenderer) {
        this.chartRenderer = chartRenderer;
    }

    public void setChartRenderer(int datasetIndex, ChartRenderer chartRenderer) {
        this.datasetIndexToChartRenderer.put(datasetIndex, chartRenderer);
    }

    public void setCoordinateMapper(CoordinateMapper chartCoordinateMapper) {
        this.chartCoordinateMapper = chartCoordinateMapper;
    }

    public void setCustomXMax(float customXMax) {
        this.customXMax = customXMax;
    }

    public void setCustomXMin(float customXMin) {
        this.customXMin = customXMin;
    }

    public void setCustomYMax(float customYMax) {
        this.customYMax = customYMax;
    }

    public void setCustomYMin(float customYMin) {
        this.customYMin = customYMin;
    }

    public void setDrawTopAndRightGridLines(boolean drawTopAndRightGridLines) {
        this.drawTopAndRightGridLines = drawTopAndRightGridLines;
    }

    public void setNoDataMessage(String noDataMessage) {
        this.noDataMessage = noDataMessage;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension size = this.getPaintSize();
        int width = size.width;
        int height = size.height;
        if (this.validImage && (this.offscreenImage.getWidth() != width || this.offscreenImage.getHeight() != height)) {
            this.validImage = false;
        }
        if (!this.validImage) {
            this.validImage = true;
            this.offscreenImage = new BufferedImage(width, height, 2);
            Graphics2D ig = (Graphics2D)this.offscreenImage.getGraphics();
            ig.setFont(new Font(UIUtil.getFontName(), 0, 12));
            ig.setColor(Color.WHITE);
            ig.fillRect(0, 0, width, height);
            this.draw(ig, this.chartCoordinateMapper, width, height);
            ig.dispose();
            this.fireChartChanged();
        }
        if (this.offscreenImage != null) {
            g2.drawImage((Image)this.offscreenImage, 0, 0, null);
        }
        this.mouseHandler.paint(g2);
    }

    void findSelectedIndices(CoordinateMapper chartCoordinateMapper, int xstart, int ystart, int lastXDragZoom, int lastYDragZoom, boolean addToSelection) {
        boolean lineFromXAxis = false;
        float lowerYValue = chartCoordinateMapper.pixToY(ystart);
        float upperYValue = chartCoordinateMapper.pixToY(lastYDragZoom);
        if (upperYValue < lowerYValue) {
            float tmp = upperYValue;
            upperYValue = lowerYValue;
            lowerYValue = tmp;
        }
        if (lastXDragZoom < xstart) {
            int tmp = lastXDragZoom;
            lastXDragZoom = xstart;
            xstart = tmp;
        }
        if (!addToSelection) {
            this.chartSelectionModel.clear();
        }
        int ndatasets = this.chartDatasets.size();
        for (int datasetIndex = 0; datasetIndex < ndatasets; ++datasetIndex) {
            XYChartDataset chartDataset = this.chartDatasets.get(datasetIndex);
            ChartRenderer renderer = this.getChartRenderer(datasetIndex);
            int seriesCount = chartDataset.getSeriesCount();
            for (int seriesIndex = 0; seriesIndex < seriesCount; ++seriesIndex) {
                int lower = renderer.getItemIndex(this, chartCoordinateMapper, chartDataset, datasetIndex, seriesIndex, xstart, ystart);
                if (lower < 0) {
                    lower = -lower - 1;
                }
                lower = Math.max(lower, 0);
                int upper = renderer.getItemIndex(this, chartCoordinateMapper, chartDataset, datasetIndex, seriesIndex, lastXDragZoom, lastYDragZoom);
                if (upper < 0) {
                    upper = -upper - 1;
                }
                upper = Math.min(upper, chartDataset.getItemCount(seriesIndex));
                for (int itemIndex = lower; itemIndex < upper; ++itemIndex) {
                    float yValue = chartDataset.getY(seriesIndex, itemIndex);
                    if (lineFromXAxis) {
                        if (!(yValue <= upperYValue)) continue;
                        this.chartSelectionModel.add(0, seriesIndex, itemIndex);
                        continue;
                    }
                    if (!(yValue <= upperYValue) || !(yValue >= lowerYValue)) continue;
                    this.chartSelectionModel.add(0, seriesIndex, itemIndex);
                }
            }
        }
        this.fireChartSelectionEvent(new ChartSelectionEvent(this, this.chartSelectionModel));
    }

    void fireChartSelectionEvent(ChartSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChartSelectionListener.class) continue;
            ((ChartSelectionListener)listeners[i + 1]).selectionChanged(event);
        }
    }

    private void drawBackgroundText(Graphics2D g2, CoordinateMapper chartCoordinateMapper) {
        g2.setColor(Color.BLACK);
        if (this.backgroundText != null) {
            Font oldFont = g2.getFont();
            int fontHeight = 80;
            g2.setFont(new Font(g2.getFont().getName(), 0, fontHeight));
            int stringWidth = g2.getFontMetrics().stringWidth(this.backgroundText);
            int maxTries = 5;
            int width = this.getWidth() - 2;
            for (int tries = 0; stringWidth > width && tries < maxTries; ++tries) {
                g2.setFont(new Font(g2.getFont().getName(), 0, fontHeight -= 10));
                stringWidth = g2.getFontMetrics().stringWidth(this.backgroundText);
            }
            Composite composite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
            g2.drawString(this.backgroundText, width / 2 - g2.getFontMetrics().stringWidth(this.backgroundText) / 2, this.getHeight() / 2);
            g2.setFont(oldFont);
            g2.setComposite(composite);
        }
    }

    private void fireChartChanged() {
        ChartChangeEvent e = new ChartChangeEvent(this);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChartChangeListener.class) continue;
            ((ChartChangeListener)listeners[i + 1]).chartChanged(e);
        }
    }

    private Map<Integer, List<SeriesAndItem>> getDatasetToSeriesAndItems(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        TreeMap<Integer, List<SeriesAndItem>> map = new TreeMap<Integer, List<SeriesAndItem>>();
        int ndatasets = this.chartDatasets.size();
        for (int datasetIndex = 0; datasetIndex < ndatasets; ++datasetIndex) {
            XYChartDataset chartDataset = this.chartDatasets.get(datasetIndex);
            ChartRenderer renderer = this.getChartRenderer(datasetIndex);
            ArrayList<SeriesAndItem> list = new ArrayList<SeriesAndItem>();
            int seriesCount = chartDataset.getSeriesCount();
            for (int seriesIndex = 0; seriesIndex < seriesCount; ++seriesIndex) {
                int itemIndex = renderer.getItemIndex(this, this.chartCoordinateMapper, chartDataset, datasetIndex, seriesIndex, x, y);
                if (itemIndex < 0) continue;
                list.add(new SeriesAndItem(seriesIndex, itemIndex));
            }
            if (list.size() <= 0) continue;
            map.put(datasetIndex, list);
        }
        return map;
    }

    private int getSeriesIndex(CoordinateMapper chartCoordinateMapper, XYChartDataset chartDataset, int datasetIndex, MouseEvent e) {
        return this.getChartRenderer(datasetIndex).getSeriesIndex(this, chartCoordinateMapper, chartDataset, datasetIndex, e.getX(), e.getY());
    }

    private void setScale(CoordinateMapper chartCoordinateMapper, int width, int height) {
        float rowGutter;
        float ymax;
        float ymin;
        float xmax;
        float xmin = this.getXMin();
        if (xmin == (xmax = this.getXMax())) {
            if (xmin == 0.0f) {
                xmax = 1.0f;
            } else {
                xmin -= Math.abs(xmin * 0.05f);
                xmax += Math.abs(xmax * 0.05f);
            }
        }
        if ((ymin = this.getYMin()) == (ymax = this.getYMax())) {
            if (ymin == 0.0f) {
                ymax = 1.0f;
            } else {
                ymin -= Math.abs(ymin * 0.05f);
                ymax += Math.abs(ymax * 0.05f);
            }
        }
        chartCoordinateMapper.setXMin(xmin);
        chartCoordinateMapper.setXMax(xmax);
        chartCoordinateMapper.setYMin(ymin);
        chartCoordinateMapper.setYMax(ymax);
        float columnGutter = Math.max(6.0f, (float)height * 0.01f);
        if (columnGutter > 6.0f) {
            columnGutter = 6.0f;
        }
        if (columnGutter < 1.0f) {
            columnGutter = 1.0f;
        }
        if ((rowGutter = Math.max(6.0f, (float)width * 0.01f)) > 6.0f) {
            rowGutter = 6.0f;
        }
        if (rowGutter < 1.0f) {
            rowGutter = 1.0f;
        }
        float gutter = this.chartRenderer.getGutter();
        rowGutter = Math.max(gutter, rowGutter);
        columnGutter = Math.max(gutter, columnGutter);
        for (ChartRenderer renderer : this.datasetIndexToChartRenderer.values()) {
            gutter = renderer.getGutter();
            rowGutter = Math.max(gutter, rowGutter);
            columnGutter = Math.max(gutter, columnGutter);
        }
        chartCoordinateMapper.setBottomGutter(columnGutter);
        chartCoordinateMapper.setTopGutter(columnGutter);
        chartCoordinateMapper.setLeftGutter(rowGutter);
        chartCoordinateMapper.setRightGutter(rowGutter);
        chartCoordinateMapper.setXYPixelScale(width, height);
    }

    private static class SeriesAndItem {
        private int item;
        private int series;

        public SeriesAndItem(int series, int item) {
            this.series = series;
            this.item = item;
        }

        public String toString() {
            return this.series + ", " + this.item;
        }
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private boolean dragging = false;
        private int lastXDragZoom = -1;
        private int lastYDragZoom = -1;
        private int xstart = -1;
        private int ystart = -1;

        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (GENEEChart.this.selectionMode == 1 && this.dragging) {
                this.lastXDragZoom = e.getX();
                this.lastYDragZoom = e.getY();
                GENEEChart.this.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() || !SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (GENEEChart.this.selectionMode == 0) {
                int selection = GENEEChart.this.getSeriesIndex(GENEEChart.this.chartCoordinateMapper, GENEEChart.this.getChartDataset(), 0, e);
                boolean removed = false;
                if (!e.isShiftDown()) {
                    GENEEChart.this.getSelectionModel().clear();
                } else {
                    removed = GENEEChart.this.getSelectionModel().remove(0, selection, -1);
                }
                if (selection >= 0 && !removed) {
                    GENEEChart.this.getSelectionModel().add(0, selection, -1);
                }
                GENEEChart.this.fireChartSelectionEvent(new ChartSelectionEvent(this, GENEEChart.this.getSelectionModel()));
                GENEEChart.this.repaint();
            } else if (GENEEChart.this.selectionMode == 2) {
                GENEEChart.this.findSelectedIndices(GENEEChart.this.chartCoordinateMapper, e.getX() - 2, e.getY() - 2, e.getX() + 2, e.getY() + 2, false);
            } else if (GENEEChart.this.selectionMode == 1) {
                this.xstart = e.getX();
                this.ystart = e.getY();
                this.lastXDragZoom = this.xstart;
                this.lastYDragZoom = this.ystart;
                this.dragging = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (GENEEChart.this.selectionMode == 1 && this.dragging) {
                this.lastXDragZoom = e.getX();
                this.lastYDragZoom = e.getY();
                GENEEChart.this.findSelectedIndices(GENEEChart.this.chartCoordinateMapper, this.xstart, this.ystart, this.lastXDragZoom, this.lastYDragZoom, e.isShiftDown());
                this.dragging = false;
                this.lastYDragZoom = -1;
                this.lastXDragZoom = -1;
                this.ystart = -1;
                this.xstart = -1;
            }
            GENEEChart.this.repaint();
        }

        void paint(Graphics2D g) {
            if (!this.dragging) {
                return;
            }
            this.drawDragRect(g, false);
        }

        private void drawDragRect(Graphics2D g, boolean xor) {
            if (this.lastXDragZoom == this.xstart && this.lastYDragZoom == this.ystart) {
                return;
            }
            int x = Math.min(this.lastXDragZoom, this.xstart);
            int y = Math.min(this.lastYDragZoom, this.ystart);
            int width = Math.abs(this.lastXDragZoom - this.xstart);
            int height = Math.abs(this.lastYDragZoom - this.ystart);
            xor = false;
            if (xor) {
                g.setPaintMode();
                g.setXORMode(Color.BLUE);
            } else {
                g.setColor(Color.BLUE);
            }
            Composite old = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, 0.1f));
            g.fillRect(x, y, width, height);
            g.setComposite(old);
        }
    }
}

