/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import javax.swing.Icon;
import javax.swing.JComboBox;
import org.broadinstitute.genee.chart.ShapeUtil;
import org.broadinstitute.genee.gui.AbstractLegend;
import org.broadinstitute.genee.gui.Highlighter;
import org.broadinstitute.genee.gui.ShapeIcon;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.io.util.Formatter;

public class ShapeByChartLegend
extends AbstractLegend {
    public ShapeByChartLegend(Highlighter chartHighlighter) {
        super(chartHighlighter);
    }

    @Override
    protected Icon createIcon(Object value) {
        Integer index = (Integer)this.visualMapper.getMappedValue(this.vector, value);
        return new ShapeIcon(ShapeUtil.getShape(index, 8.0f));
    }

    @Override
    protected void showEditDialog(Object value) {
        JComboBox comboBox = UIUtil.createComboBox();
        for (int i = 0; i < 7; ++i) {
            ShapeIcon icon = new ShapeIcon(ShapeUtil.getShape(i, 8.0f));
            comboBox.addItem(icon);
        }
        int index = (Integer)this.visualMapper.getMappedValue(this.vector, value);
        comboBox.setSelectedIndex(index);
        if (UIUtil.showOkCancelDialog(comboBox, comboBox, Formatter.toString(value) + " Shape")) {
            this.visualMapper.setMappedValue(this.vector, value, comboBox.getSelectedIndex());
        }
    }
}

