/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.broadinstitute.genee.chart.ColorSizeShapeAttribute;
import org.broadinstitute.genee.chart.SizeByChartLegend;
import org.broadinstitute.genee.gui.Highlighter;
import org.broadinstitute.genee.heatmap.WorldCoordinateMapper;
import org.broadinstitute.genee.matrix.OrientedVector;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public abstract class SizeBy
extends ColorSizeShapeAttribute {
    private boolean continuous;
    private Map<Object, Float> valueToPercent = new TreeMap<Object, Float>();
    private Highlighter highlighter = new Highlighter(){

        @Override
        protected void notifyChanged() {
            SizeBy.this.notifyHighlighterChanged();
        }
    };

    public SizeBy() {
        this.legend = new SizeByChartLegend(this.highlighter);
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public Map<Object, Float> getValueToPercent() {
        return this.valueToPercent;
    }

    @Override
    public void setVector(OrientedVector v) {
        this.vector = v;
        this.valueToPercent.clear();
        Vector vectorInSelectedIndicesSpace = this.getVectorInSelectedIndicesSpace(this.vector);
        if (vectorInSelectedIndicesSpace != null) {
            this.valueToPercent = SizeBy.createValueToSizeMap(vectorInSelectedIndicesSpace, this.continuous);
        }
        this.highlighter.clearHighlighted(false);
    }

    @Override
    public void updateLegend() {
        ((SizeByChartLegend)this.legend).setValueToPercent(this.valueToPercent);
        this.legend.setValues(this.valueToPercent.size() > 0 ? this.valueToPercent.keySet() : null);
    }

    private static Map<Object, Float> createValueToSizeMap(Vector vector, boolean continuous) {
        TreeMap<Object, Float> valueToPercentMaxSize;
        block7: {
            TreeMap<Object, Float> treeMap = valueToPercentMaxSize = vector != null && vector.getComparator() != null ? new TreeMap<Object, Float>(vector.getComparator()) : new TreeMap<Object, Float>();
            if (vector == null) break block7;
            if (continuous) {
                continuous = Number.class.isAssignableFrom(vector.getColumnClass());
            }
            Set values = VectorUtil.getValues(vector);
            if (!continuous) {
                for (Object value : values) {
                    valueToPercentMaxSize.put(value, Float.valueOf(0.0f));
                }
                float step = valueToPercentMaxSize.size() == 1 ? 0.0f : 1.0f / (float)valueToPercentMaxSize.size();
                float percent = 0.0f;
                for (Object value : valueToPercentMaxSize.keySet()) {
                    valueToPercentMaxSize.put(value, Float.valueOf(percent));
                    percent += step;
                }
            } else {
                float min = VectorUtil.getMin(vector);
                float max = VectorUtil.getMax(vector);
                for (Object value : values) {
                    float f;
                    Number n = (Number)value;
                    float percent = 0.0f;
                    if (n != null && !Float.isNaN(f = n.floatValue())) {
                        percent = WorldCoordinateMapper.linearScale(f, min, max, 0.0f, 1.0f);
                    }
                    valueToPercentMaxSize.put(value, Float.valueOf(percent));
                }
            }
        }
        return valueToPercentMaxSize;
    }
}

