/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical;

import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.category.QualitativeColorSchemes;
import org.broadinstitute.genee.clustering.hierarchical.Node;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.LinkageMethod;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Correlation;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.gui.Interpolation;
import org.broadinstitute.genee.gui.SplitEvent;
import org.broadinstitute.genee.gui.SplitListener;
import org.broadinstitute.genee.gui.Splittable;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.CoordinateMapper;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.heatmap.WorldCoordinateMapper;
import org.broadinstitute.genee.heatmap.menu.DefaultNodeColorScheme;
import org.broadinstitute.genee.heatmap.menu.NodeColorScheme;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.math.adjust.LogScaleUnivariateFunction;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.math.stat.function.Sum;
import org.broadinstitute.genee.matrix.ArrayFloatList;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.SplineInterpolator;

public abstract class AbstractDendrogramPanel
extends JPanel
implements Drawable,
Splittable {
    private static final Composite composite = AlphaComposite.getInstance(3, 0.5f);
    protected Arc2D.Float arc = new Arc2D.Float(2);
    protected boolean colorDendrogram = false;
    protected CoordinateMapper coordinateMapper;
    protected float cutTreePosition;
    protected float defaultCutTreePosition;
    protected Color defaultNodeColor = Color.BLACK;
    protected float dendrogramLineThickness = 1.0f;
    protected boolean drawLeafNodes = true;
    protected boolean drawPieChart = false;
    protected Ellipse2D.Float ellipse = new Ellipse2D.Float();
    protected GeneralPath generalPath = new GeneralPath();
    protected Node hoverNode;
    protected String[] leafNodeIds;
    protected Map<String, Node> leafNodes;
    protected float maxDistance;
    protected float minDistance;
    protected NodeColorScheme nodeColorScheme = new DefaultNodeColorScheme();
    protected Node[] rootNodes;
    protected Color selectedColor = UIUtil.SELECTION_COLOR;
    protected Node selectedNode = null;
    protected SizesAndPositions sizesAndPositions;
    private NodeScores activeNodeScores;
    private FloatListFunction adjustDataFunction;
    private Animator animator;
    private int clusterNumber = 0;
    private DistanceFunction distanceFunction;
    private NodeScores dynamicNodeScores = new NodeScores();
    private BufferedImage image;
    private int lastMax = -1;
    private int lastMin = -1;
    private LinkageMethod linkageMethod;
    private float maxDiameter = 20.0f;
    private float minDiameter = 6.0f;
    private boolean negativeLog2 = true;
    private Rectangle savedRect;
    private boolean scaleSplitsToDistance = false;
    private CoordinateMapper splitCoordinateMapper;
    private float[] splitDistances;
    private int splitPixelSize = 50;
    private NodeScores staticNodeScores = new NodeScores();

    protected AbstractDendrogramPanel(Map<String, Node> leafNodes, Node[] rootNodes, String[] leafNodeIds, SizesAndPositions sizesAndPositions, DistanceFunction distanceFunction, LinkageMethod linkageMethod) {
        this.coordinateMapper = new WorldCoordinateMapper();
        if (!this.isShowingRows()) {
            this.coordinateMapper.setTopGutter(1.0f);
            this.coordinateMapper.setBottomGutter(1.0f);
        } else {
            this.coordinateMapper.setLeftGutter(1.0f);
            this.coordinateMapper.setRightGutter(1.0f);
        }
        this.sizesAndPositions = sizesAndPositions;
        MyMouseListener l = new MyMouseListener();
        this.addMouseListener(l);
        this.addMouseMotionListener(l);
        this.leafNodes = leafNodes;
        this.rootNodes = rootNodes;
        this.leafNodeIds = leafNodeIds;
        if (distanceFunction == null) {
            distanceFunction = new Correlation();
        }
        if (linkageMethod == null) {
            linkageMethod = LinkageMethod.AVERAGE_LINKAGE;
        }
        this.setBackground(Color.WHITE);
        this.linkageMethod = linkageMethod;
        this.distanceFunction = distanceFunction;
        this.splitCoordinateMapper = new WorldCoordinateMapper();
        this.setFocusable(true);
        this.setDoubleBuffered(false);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.listenerList.add(ListSelectionListener.class, l);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        UIUtil.registerToolTip(this);
    }

    @Override
    public void addSplitListener(SplitListener l) {
        this.listenerList.add(SplitListener.class, l);
    }

    public void cutSelectedNode() {
        if (this.selectedNode == null || this.selectedNode.isLeaf()) {
            return;
        }
        float[] spaces = new float[this.sizesAndPositions.getLength()];
        this.selectedNode.setCut(true, false);
        this.selectedNode.getRight().setCut(false, true);
        this.selectedNode.getLeft().setCut(false, true);
        this.selectedNode.getLeft().setClusterColor(this.createClusterColor());
        this.selectedNode.getRight().setClusterColor(this.createClusterColor());
        TIntArrayList gapIndices = this.getGapIndices();
        int length = gapIndices.size();
        for (int i = 0; i < length; ++i) {
            int splitIndex = gapIndices.getQuick(i);
            spaces[splitIndex] = 10.0f;
        }
        this.transitionTo(spaces, this.cutTreePosition);
    }

    public void deselectSelectedNode() {
        if (this.selectedNode != null) {
            this.selectedNode.setSelected(false);
            this.repaintImage();
        }
    }

    @Override
    public void draw(Graphics g, Rectangle rect) {
        this._internalDraw((Graphics2D)g, rect);
    }

    public void drawBFS(Graphics2D g2, Node node, int minIndex, int maxIndex) {
        if (node.getMaxIndex() < minIndex || node.getMinIndex() > maxIndex) {
            return;
        }
        LinkedList<Node> q = new LinkedList<Node>();
        q.add(node);
        while (!q.isEmpty()) {
            Node n = (Node)q.removeFirst();
            this.drawSingleNode(g2, n, minIndex, maxIndex);
            if (n.left != null) {
                q.addFirst(n.left);
            }
            if (n.right == null) continue;
            q.addFirst(n.right);
        }
    }

    public void drawDFS(Graphics2D g2, Node node, int minIndex, int maxIndex) {
        if (node.getMaxIndex() < minIndex || node.getMinIndex() > maxIndex) {
            return;
        }
        Node left = node.getLeft();
        Node right = node.getRight();
        this.drawSingleNode(g2, node, minIndex, maxIndex);
        if (!left.isLeaf()) {
            this.drawDFS(g2, left, minIndex, maxIndex);
        }
        if (!right.isLeaf()) {
            this.drawDFS(g2, right, minIndex, maxIndex);
        }
    }

    public int[] flip() {
        if (this.selectedNode == null || this.selectedNode.isLeaf()) {
            return null;
        }
        Node left = this.selectedNode.getLeft();
        Node right = this.selectedNode.getRight();
        this.selectedNode.setRight(left);
        this.selectedNode.setLeft(right);
        int min = this.selectedNode.getMinIndex();
        int max = this.selectedNode.getMaxIndex();
        String[] tempIds = (String[])this.leafNodeIds.clone();
        int i = min;
        int index = max;
        while (i <= max) {
            Node n = this.leafNodes.get(this.leafNodeIds[i]);
            n.setIndex(index);
            n.setMaxIndex(index);
            n.setMinIndex(index);
            tempIds[i] = this.leafNodeIds[index];
            ++i;
            --index;
        }
        this.leafNodeIds = tempIds;
        this.recomputeIndicesAndPosition();
        return new int[]{min, max};
    }

    public Color getColor() {
        return this.defaultNodeColor;
    }

    public float getCutTreePosition() {
        return this.cutTreePosition;
    }

    public float getDendrogramLineThickness() {
        return this.dendrogramLineThickness;
    }

    @Override
    public DistanceFunction getDistanceFunction() {
        return this.distanceFunction;
    }

    @Override
    public LinkageMethod getLinkageMethod() {
        return this.linkageMethod;
    }

    public NodeColorScheme getNodeColorScheme() {
        return this.nodeColorScheme;
    }

    public Map<String, float[]> getNodeIdToScore(boolean dynamic) {
        return this.getNodeScores(dynamic).nodeToScores;
    }

    public abstract void getNodePosition(Node var1, Point2D.Float var2);

    public String[] getNodeScoreNames(boolean dynamic) {
        return this.getNodeScores((boolean)dynamic).nodeScoreNames;
    }

    public NodeScoreSource getNodeScoreSource() {
        if (this.activeNodeScores == null) {
            return NodeScoreSource.NODE_SCORE_SOURCE_NONE;
        }
        return this.activeNodeScores == this.dynamicNodeScores ? NodeScoreSource.NODE_SCORE_SOURCE_DYNAMIC : NodeScoreSource.NODE_SCORE_SOURCE_STATIC;
    }

    public Color getPieChartColor(boolean dynamic, String name) {
        return this.getNodeScores((boolean)dynamic).pieChartPartColors.get(name);
    }

    public Node getSelectedNode() {
        return this.selectedNode;
    }

    @Override
    public float[] getSplitDistances() {
        return this.splitDistances;
    }

    @Override
    public int getSplitPixelSize() {
        return this.splitPixelSize;
    }

    public float getSplitPixPerUnit() {
        return this.splitCoordinateMapper.getXPixPerUnit();
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this.containsCutTreeSlider(e)) {
            return "Cut position: " + Formatter.format(this.cutTreePosition);
        }
        Node node = this.getNode(e);
        if (node == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(node.getId());
        buf.append(": ");
        buf.append(Formatter.format(node.distance));
        Float pValue = this.nodeColorScheme.getValue(node.getId());
        if (pValue != null) {
            buf.append(", Significance: ");
            buf.append(Formatter.format(pValue.floatValue()));
        }
        if (this.activeNodeScores != null && this.activeNodeScores.nodeToScores != null && this.activeNodeScores.nodeToScores.containsKey(node.getId())) {
            buf.append(", Node data: ");
            float[] scores = (float[])this.activeNodeScores.nodeToScores.get(node.getId());
            int length = scores.length;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(Formatter.format(scores[i]));
            }
        }
        return buf.toString();
    }

    public boolean isColorNodes() {
        return this.colorDendrogram;
    }

    public boolean isCutTreeSliderDefault() {
        return this.cutTreePosition == this.defaultCutTreePosition;
    }

    public boolean isDrawPieChart() {
        return this.drawPieChart;
    }

    public boolean isNegativeLog2() {
        return this.negativeLog2;
    }

    @Override
    public boolean isScaleSplitsToDistance() {
        return this.scaleSplitsToDistance;
    }

    public void recomputeIndicesAndPosition() {
        if (this.rootNodes == null) {
            return;
        }
        for (Node root : this.rootNodes) {
            root.recomputeIndicesAndPosition(this.sizesAndPositions);
        }
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.listenerList.remove(ListSelectionListener.class, l);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        UIUtil.unregisterToolTip(this);
    }

    @Override
    public void removeSplitListener(SplitListener l) {
        this.listenerList.remove(SplitListener.class, l);
    }

    public void repaintImage() {
        this.lastMin = -2147483647;
        this.lastMax = -2147483647;
        this.repaint();
    }

    public void resetCut() {
        for (Node root : this.rootNodes) {
            root.resetCut();
        }
        this.transitionTo(new float[this.sizesAndPositions.getLength()], 0.0f);
    }

    @Override
    public void revalidate() {
        this.recomputeIndicesAndPosition();
        super.revalidate();
    }

    @Override
    public void setAdjustDistancesFunction(FloatListFunction f) {
        this.adjustDataFunction = f;
    }

    public void setColor(Color c) {
        this.defaultNodeColor = c;
        for (Node root : this.rootNodes) {
            root.setColor(c);
        }
    }

    public void setColorNodes(boolean colorNodes) {
        this.colorDendrogram = colorNodes;
    }

    public void setDendrogramLineThickness(float dendrogramLineThickness) {
        this.dendrogramLineThickness = dendrogramLineThickness;
    }

    @Override
    public void setDistanceFunction(DistanceFunction distanceFunction) {
        this.distanceFunction = distanceFunction;
    }

    public void setDrawLeafNodes(boolean drawLeafNodes) {
        this.drawLeafNodes = drawLeafNodes;
    }

    public void setDrawPieChart(boolean drawPieChart) {
        this.drawPieChart = drawPieChart;
        this.updatePieChartScale(this.activeNodeScores);
    }

    @Override
    public void setLinkageMethod(LinkageMethod linkageMethod) {
        this.linkageMethod = linkageMethod;
    }

    public abstract void setMax(float var1);

    public void setMaxDiameter(float maxRadius) {
        this.maxDiameter = maxRadius;
        this.updatePieChartScale(this.activeNodeScores);
    }

    public abstract void setMin(float var1);

    public void setMinDiameter(float minRadius) {
        this.minDiameter = minRadius;
        this.updatePieChartScale(this.activeNodeScores);
    }

    public void setNegativeLog2(boolean negativeLog2) {
        this.negativeLog2 = negativeLog2;
        this.updatePieChartScale(this.activeNodeScores);
    }

    public void setNodeIdToScores(boolean dynamic, Map<String, float[]> nodeIdToScores) {
        if (nodeIdToScores == null) {
            nodeIdToScores = new HashMap<String, float[]>();
        }
        this.getNodeScores(dynamic).nodeToScores = nodeIdToScores;
    }

    public void setNodes(Map<String, Node> map) {
        this.leafNodes = map;
    }

    public void setNodeScoreNames(boolean dynamic, String[] names) {
        this.setNodeScoreNames(this.getNodeScores(dynamic), names);
    }

    public void setNodeScoreSource(NodeScoreSource nodeScoreSource) {
        this.activeNodeScores = nodeScoreSource.equals((Object)NodeScoreSource.NODE_SCORE_SOURCE_STATIC) ? this.staticNodeScores : (nodeScoreSource.equals((Object)NodeScoreSource.NODE_SCORE_SOURCE_DYNAMIC) ? this.dynamicNodeScores : null);
        this.updatePieChartScale(this.activeNodeScores);
    }

    public void setPieChartColor(boolean dynamic, String name, Color color) {
        this.getNodeScores((boolean)dynamic).pieChartPartColors.put(name, color);
    }

    public void setPieChartColumnIndices(boolean dynamic, int[] indices) {
        NodeScores nodeScores = this.getNodeScores(dynamic);
        NodeScores.access$202(nodeScores, indices);
        this.updatePieChartScale(nodeScores);
    }

    @Override
    public void setScaleSplitsToDistance(boolean scaleSplitsToDistance) {
        this.scaleSplitsToDistance = scaleSplitsToDistance;
    }

    public void setSelectedNode(MouseEvent e) {
        if (this.selectedNode != null) {
            this.selectedNode.setSelected(false);
        }
        this.selectedNode = this.getNode(e);
        if (this.selectedNode != null) {
            this.selectedNode.setSelected(true);
        }
        this.repaintImage();
        this.notifyListSelectionListeners();
    }

    public void setSelectedNode(Node n) {
        this.selectedNode = n;
    }

    public void setSelectedNodeColor(Color color) {
        if (this.selectedNode != null) {
            this.selectedNode.setRootColor(color);
        }
    }

    @Override
    public void setSplitPixelSize(int size) {
        this.splitPixelSize = size;
    }

    @Override
    public void split() {
        if (this.isCutTreeSliderDefault()) {
            return;
        }
        this.clusterNumber = 0;
        float currentCutTreePosition = this.cutTreePosition;
        for (Node root : this.rootNodes) {
            this.cutDendrogramDFS(root, currentCutTreePosition);
        }
        TIntArrayList gapIndices = this.getGapIndices();
        float[] sizes = new float[this.sizesAndPositions.getLength()];
        if (this.scaleSplitsToDistance) {
            Dataset dataset = !this.isShowingRows() ? DatasetUtil.transposeView(Application.getProject().getSortedFilteredDataset()) : Application.getProject().getSortedFilteredDataset();
            this.splitDistances = new float[gapIndices.size()];
            int length = gapIndices.size();
            for (int i = 0; i < length; ++i) {
                int[][] indices = this.getIndicesForSplit(gapIndices, i, dataset.getRowCount());
                this.splitDistances[i] = this.getClusterDistance(dataset, indices[0], indices[1]);
            }
            if (this.adjustDataFunction != null) {
                ArrayFloatList list = new ArrayFloatList(this.splitDistances);
                this.adjustDataFunction.evaluate(list);
            }
            float sum = new Sum().evaluate(new ArrayFloatList(this.splitDistances));
            int i = 0;
            int length2 = this.splitDistances.length;
            while (i < length2) {
                int n = i++;
                this.splitDistances[n] = this.splitDistances[n] / sum;
            }
            this.splitCoordinateMapper.setXMax(this.maxDistance);
            this.splitCoordinateMapper.setXMin(this.minDistance);
            this.splitCoordinateMapper.setXPixelScale(this.splitPixelSize);
            length2 = gapIndices.size();
            for (i = 0; i < length2; ++i) {
                float splitSize;
                int splitIndex = gapIndices.getQuick(i);
                float distance = this.splitDistances[i];
                sizes[splitIndex] = splitSize = this.splitCoordinateMapper.xToPix(distance);
            }
        } else {
            int length = gapIndices.size();
            for (int i = 0; i < length; ++i) {
                int splitIndex = gapIndices.getQuick(i);
                sizes[splitIndex] = 10.0f;
            }
        }
        this.transitionTo(sizes, currentCutTreePosition);
    }

    protected abstract boolean containsCutTreeSlider(MouseEvent var1);

    protected abstract void drawHoverNode(Graphics2D var1, Node var2);

    protected void drawPieChart(Graphics2D g2, Node node, float x, float y) {
        if (this.drawPieChart && this.activeNodeScores.pieChartColumnIndices != null) {
            float[] scores = (float[])this.activeNodeScores.nodeToScores.get(node.getId());
            if (scores == null) {
                return;
            }
            Color oldColor = g2.getColor();
            Composite oldComposite = g2.getComposite();
            g2.setComposite(composite);
            float sum = 0.0f;
            int length = this.activeNodeScores.pieChartColumnIndices.length;
            for (int i = 0; i < length; ++i) {
                int index = this.activeNodeScores.pieChartColumnIndices[i];
                float d = scores[index];
                if (Float.isNaN(d)) continue;
                sum += d;
            }
            float size = this.getPixelSize(sum);
            this.ellipse.x = x - size / 2.0f;
            this.ellipse.y = y - size / 2.0f;
            this.ellipse.width = size;
            this.ellipse.height = size;
            this.arc.x = this.ellipse.x;
            this.arc.y = this.ellipse.y;
            this.arc.width = this.ellipse.width;
            this.arc.height = this.ellipse.height;
            int start = 0;
            int length2 = this.activeNodeScores.pieChartColumnIndices.length;
            for (int i = 0; i < length2; ++i) {
                int index = this.activeNodeScores.pieChartColumnIndices[i];
                String name = this.activeNodeScores.nodeScoreNames[index];
                g2.setColor(this.activeNodeScores.pieChartPartColors.get(name));
                float value = scores[index];
                int extent = Math.round(value / sum * 360.0f);
                int total = extent + start;
                if (i == length2 - 1 && total != 360) {
                    extent += 360 - total;
                }
                this.arc.start = start;
                this.arc.extent = extent;
                g2.fill(this.arc);
                start += extent;
            }
            g2.setColor(oldColor);
            g2.setComposite(oldComposite);
        }
    }

    protected abstract void drawSingleNode(Graphics2D var1, Node var2, int var3, int var4);

    protected abstract int getMaxIndex(Rectangle var1);

    protected abstract int getMinIndex(Rectangle var1);

    protected abstract Node getNode(MouseEvent var1);

    protected Color getNodeColor(Node node) {
        Color color = node.getColor();
        if (color == null) {
            if (node.isHighlighted()) {
                color = UIUtil.HIGHLIGHT_COLOR;
            } else if (node.isSelected()) {
                color = this.selectedColor;
            }
        }
        if (color == null) {
            if (node.isCut()) {
                color = Color.LIGHT_GRAY;
            } else if (node.getClusterColor() != null) {
                color = node.getClusterColor();
            }
        }
        if (color == null) {
            color = this.colorDendrogram ? this.nodeColorScheme.getColor(node.getId()) : this.defaultNodeColor;
        }
        return color;
    }

    protected float getPixelSize(float score) {
        if (this.negativeLog2) {
            score = -LogScaleUnivariateFunction.log2(score);
        }
        return this.activeNodeScores.nodePixPerUnit * score - this.activeNodeScores.pieChartMin * this.activeNodeScores.nodePixPerUnit + this.minDiameter;
    }

    protected abstract boolean isShowingRows();

    protected void notifyListSelectionListeners() {
        ListSelectionEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListSelectionListener.class) continue;
            if (e == null) {
                int min = this.selectedNode != null ? this.selectedNode.getMinIndex() : -1;
                int max = this.selectedNode != null ? this.selectedNode.getMaxIndex() : -1;
                e = new ListSelectionEvent(this, min, max, false);
            }
            ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    protected void notifySplitListeners() {
        SplitEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SplitListener.class) continue;
            if (e == null) {
                e = new SplitEvent(this);
            }
            ((SplitListener)listeners[i + 1]).splitChanged(e);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isVisible()) {
            Rectangle rect = this.getVisibleRect();
            int min = this.getMinIndex(rect);
            int max = this.getMaxIndex(rect);
            if (!rect.equals(this.savedRect) || min != this.lastMin || max != this.lastMax) {
                this.savedRect = rect;
                this.lastMin = min;
                this.lastMax = max;
                this.image = new BufferedImage(rect.width, rect.height, 2);
                Graphics2D imageGraphics = (Graphics2D)this.image.getGraphics();
                imageGraphics.setColor(Color.WHITE);
                imageGraphics.fillRect(0, 0, rect.width, rect.height);
                if (!this.isShowingRows()) {
                    imageGraphics.translate(-rect.x, 0);
                } else {
                    imageGraphics.translate(0, -rect.y);
                }
                this._internalDraw(imageGraphics, rect);
                imageGraphics.dispose();
            }
            if (!this.isShowingRows()) {
                g.drawImage(this.image, rect.x, 0, null);
            } else {
                g.drawImage(this.image, 0, rect.y, null);
            }
            if (this.hoverNode != null) {
                this.drawHoverNode((Graphics2D)g, this.hoverNode);
            }
        }
    }

    protected void setMinMaxDistance(float minDistance, float maxDistance) {
        if (minDistance > maxDistance) {
            float tmp = maxDistance;
            maxDistance = minDistance;
            minDistance = tmp;
        }
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
    }

    private void _internalDraw(Graphics2D g, Rectangle rect) {
        int min = this.getMinIndex(rect);
        int max = this.getMaxIndex(rect);
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(this.dendrogramLineThickness));
        this.coordinateMapper.setXPixelScale(rect.width);
        this.coordinateMapper.setYPixelScale(rect.height);
        for (Node rootNode : this.rootNodes) {
            this.drawDFS(g, rootNode, min, max);
        }
    }

    private Color createClusterColor() {
        Color c = QualitativeColorSchemes.getTwentyColor(this.clusterNumber);
        ++this.clusterNumber;
        return c;
    }

    private void cutDendrogramDFS(Node node, float cutTreePosition) {
        Node left = node.getLeft();
        Node right = node.getRight();
        if (node.getDistance() < cutTreePosition) {
            node.setCut(false, true);
            if (node.getParent() != null && node.getParent().isCut()) {
                Color c = this.createClusterColor();
                node.setClusterColor(c);
            }
        } else if (!node.isCut()) {
            node.setCut(true, true);
            node.setClusterColor(null);
        }
        if (!left.isLeaf()) {
            this.cutDendrogramDFS(left, cutTreePosition);
        }
        if (!right.isLeaf()) {
            this.cutDendrogramDFS(right, cutTreePosition);
        }
    }

    private float getClusterDistance(Dataset dataset, int[] clusterOneIndices, int[] clusterTwoIndices) {
        float sum = 0.0f;
        float[] weight = new float[dataset.getColumnCount()];
        Arrays.fill(weight, 1.0f);
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        int size = clusterOneIndices.length;
        for (int i = 0; i < size; ++i) {
            int size2 = clusterTwoIndices.length;
            for (int j = 0; j < size2; ++j) {
                float dist = this.distanceFunction.evaluate(dataset, dataset, weight, clusterOneIndices[i], clusterTwoIndices[j]);
                if (Float.isNaN(dist)) continue;
                sum += dist;
                min = Math.min(min, dist);
                max = Math.max(max, dist);
            }
        }
        if (this.linkageMethod.equals((Object)LinkageMethod.SINGLE_LINKAGE)) {
            return min;
        }
        if (this.linkageMethod.equals((Object)LinkageMethod.COMPLETE_LINKAGE)) {
            return max;
        }
        if (this.linkageMethod.equals((Object)LinkageMethod.AVERAGE_LINKAGE)) {
            return sum /= (float)(clusterOneIndices.length * clusterTwoIndices.length);
        }
        throw new RuntimeException();
    }

    private TIntArrayList getGapIndices() {
        TIntArrayList splits = new TIntArrayList();
        for (int i = 1; i < this.leafNodeIds.length; ++i) {
            Node leaf = this.leafNodes.get(this.leafNodeIds[i]);
            if (!leaf.isCut() && (leaf.getClusterColor() == null || leaf.getClusterColor().equals(this.leafNodes.get(this.leafNodeIds[i - 1]).getClusterColor()))) continue;
            splits.add(i - 1);
        }
        return splits;
    }

    private int[][] getIndicesForSplit(TIntArrayList splits, int index, int size) {
        int prior = index == 0 ? -1 : splits.getQuick(index - 1);
        int splitIndex = splits.getQuick(index);
        int next = index == splits.size() - 1 ? size - 1 : splits.getQuick(index + 1);
        int[] lowerIndices = new int[splitIndex - prior];
        int i = 0;
        int j = prior + 1;
        while (j <= splitIndex) {
            lowerIndices[i] = j++;
            ++i;
        }
        int[] upperIndices = new int[next - splitIndex];
        int i2 = 0;
        int j2 = splitIndex + 1;
        while (j2 <= next) {
            upperIndices[i2] = j2++;
            ++i2;
        }
        int[][] result = new int[][]{lowerIndices, upperIndices};
        return result;
    }

    private NodeScores getNodeScores(boolean dynamic) {
        return dynamic ? this.dynamicNodeScores : this.staticNodeScores;
    }

    private void mouseDraggedCutTreeSlider(MouseEvent e) {
        float max;
        boolean isRows = this.isShowingRows();
        this.cutTreePosition = isRows ? this.coordinateMapper.pixToX(e.getX()) : this.coordinateMapper.pixToY(e.getY());
        float min = isRows ? this.coordinateMapper.getXMin() : this.coordinateMapper.getYMin();
        float f = max = isRows ? this.coordinateMapper.getXMax() : this.coordinateMapper.getYMax();
        if (min > max) {
            float tmp = max;
            max = min;
            min = tmp;
        }
        if (this.cutTreePosition < min) {
            this.cutTreePosition = min;
        }
        if (this.cutTreePosition > max) {
            this.cutTreePosition = max;
        }
    }

    private void setNodeScoreNames(NodeScores nodeScores, String[] names) {
        this.drawPieChart = names == null ? false : names.length >= 1;
        if (names != null) {
            Color[] colors = UIUtil.rainbow(names.length);
            int length = names.length;
            for (int i = 0; i < length; ++i) {
                String name = names[i];
                if (nodeScores.pieChartPartColors.containsKey(name)) continue;
                nodeScores.pieChartPartColors.put(name, colors[i]);
            }
        }
        NodeScores.access$202(nodeScores, new int[names != null ? names.length : 0]);
        int length = nodeScores.pieChartColumnIndices.length;
        for (int i = 0; i < length; ++i) {
            ((NodeScores)nodeScores).pieChartColumnIndices[i] = i;
        }
        nodeScores.nodeScoreNames = names;
        this.updatePieChartScale(this.activeNodeScores);
    }

    private void transitionTo(final float[] sizes, float cutTreePosition) {
        if (this.animator != null) {
            this.animator.cancel();
        }
        this.animator = new Animator(200, new TimingTarget(){
            float[] current;
            float[] state;
            {
                this.current = AbstractDendrogramPanel.this.sizesAndPositions.getSpaceSizes();
                this.state = new float[sizes.length];
            }

            @Override
            public void begin() {
            }

            @Override
            public void end() {
                AbstractDendrogramPanel.this.sizesAndPositions.setSpaceSizes(this.state);
                AbstractDendrogramPanel.this.sizesAndPositions.notifyListeners(2);
                AbstractDendrogramPanel.this.notifySplitListeners();
            }

            @Override
            public void repeat() {
            }

            @Override
            public void timingEvent(float f) {
                Interpolation.interpolate(f, this.current, sizes, this.state);
                AbstractDendrogramPanel.this.sizesAndPositions.setSpaceSizes(this.state);
                AbstractDendrogramPanel.this.sizesAndPositions.notifyListeners(2);
            }
        });
        this.animator.setInterpolator(new SplineInterpolator(0.0f, 1.0f, 1.0f, 0.0f));
        this.animator.setAcceleration(0.2f);
        this.animator.setDeceleration(0.8f);
        this.animator.start();
    }

    private void updatePieChartScale(NodeScores nodeScores) {
        if (nodeScores != null && nodeScores.pieChartColumnIndices != null) {
            TFloatArrayList bin = AbstractDendrogramPanel.getBin(nodeScores.nodeToScores, nodeScores.pieChartColumnIndices, this.negativeLog2);
            float min = bin.size() == 0 ? 0.0f : bin.min();
            float max = bin.size() == 0 ? 0.0f : bin.max();
            nodeScores.pieChartMin = min;
            nodeScores.pieChartMax = max;
            nodeScores.nodePixPerUnit = (this.maxDiameter - this.minDiameter) / (max - min);
        }
    }

    public static TFloatArrayList getBin(Map<String, float[]> nodeToScores, int[] indices, boolean negativeLog2) {
        TFloatArrayList bin = new TFloatArrayList();
        for (String id : nodeToScores.keySet()) {
            float sumValue = 0.0f;
            boolean found = false;
            float[] scores = nodeToScores.get(id);
            int length = indices.length;
            for (int i = 0; i < length; ++i) {
                float score = scores[indices[i]];
                if (Float.isNaN(score)) continue;
                if (negativeLog2) {
                    score = -LogScaleUnivariateFunction.log2(score);
                }
                sumValue += score;
                found = true;
            }
            if (!found) continue;
            bin.add(sumValue);
        }
        return bin;
    }

    private static class NodeScores {
        protected String[] nodeScoreNames;
        protected Map<String, Color> pieChartPartColors = new HashMap<String, Color>();
        private float nodePixPerUnit;
        private Map<String, float[]> nodeToScores;
        private int[] pieChartColumnIndices;
        private float pieChartMax;
        private float pieChartMin;

        private NodeScores() {
        }

        static /* synthetic */ int[] access$202(NodeScores x0, int[] x1) {
            x0.pieChartColumnIndices = x1;
            return x1;
        }
    }

    private class MyMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean overSlider;
        private Timer timer;

        MyMouseListener() {
            this.timer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractDendrogramPanel.this.split();
                    AbstractDendrogramPanel.this.repaintImage();
                }
            });
            this.timer.setRepeats(false);
            this.timer.setCoalesce(true);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if ((e.getModifiers() & 4) != 4 && !e.isPopupTrigger() && !this.timer.isRunning()) {
                AbstractDendrogramPanel.this.setSelectedNode(e);
            }
            AbstractDendrogramPanel.this.requestFocusInWindow();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.overSlider) {
                AbstractDendrogramPanel.this.mouseDraggedCutTreeSlider(e);
                if (AbstractDendrogramPanel.this.isCutTreeSliderDefault()) {
                    AbstractDendrogramPanel.this.resetCut();
                    AbstractDendrogramPanel.this.repaint();
                } else {
                    this.timer.restart();
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AbstractDendrogramPanel.this.hoverNode = null;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int cursor = -1;
            cursor = AbstractDendrogramPanel.this.containsCutTreeSlider(e) ? 12 : (AbstractDendrogramPanel.this.hoverNode != null ? 12 : 0);
            AbstractDendrogramPanel.this.hoverNode = AbstractDendrogramPanel.this.getNode(e);
            AbstractDendrogramPanel.this.setCursor(Cursor.getPredefinedCursor(cursor));
            AbstractDendrogramPanel.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.overSlider = AbstractDendrogramPanel.this.containsCutTreeSlider(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.overSlider) {
                AbstractDendrogramPanel.this.mouseDraggedCutTreeSlider(e);
                this.timer.restart();
            } else {
                AbstractDendrogramPanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.overSlider = false;
        }
    }

    public static enum NodeScoreSource {
        NODE_SCORE_SOURCE_DYNAMIC,
        NODE_SCORE_SOURCE_NONE,
        NODE_SCORE_SOURCE_STATIC;

    }
}

