/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical.algorithm.linkage;

import org.broadinstitute.genee.clustering.hierarchical.algorithm.ClosestPairResult;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.HCLCluster;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.Node;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.linkage.LinkageAlgorithm;

public class AverageLinkage
implements LinkageAlgorithm {
    @Override
    public Node[] cluster(int nelements, float[][] distmatrix) {
        int j;
        int[] clusterid = new int[nelements];
        int[] number = new int[nelements];
        Node[] result = new Node[nelements - 1];
        for (int i = 0; i < nelements - 1; ++i) {
            result[i] = new Node();
        }
        for (j = 0; j < nelements; ++j) {
            number[j] = 1;
            clusterid[j] = j;
        }
        ClosestPairResult r = new ClosestPairResult();
        for (int n = nelements; n > 1; --n) {
            HCLCluster.find_closest_pair(n, distmatrix, r);
            result[nelements - n] = new Node();
            result[nelements - n].distance = r.distance;
            int is = r.ip;
            int js = r.jp;
            result[nelements - n].left = clusterid[is];
            result[nelements - n].right = clusterid[js];
            int sum = number[is] + number[js];
            j = 0;
            while (j < js) {
                distmatrix[js][j] = distmatrix[is][j] * (float)number[is] + distmatrix[js][j] * (float)number[js];
                float[] fArray = distmatrix[js];
                int n2 = j++;
                fArray[n2] = fArray[n2] / (float)sum;
            }
            for (j = js + 1; j < is; ++j) {
                distmatrix[j][js] = distmatrix[is][j] * (float)number[is] + distmatrix[j][js] * (float)number[js];
                float[] fArray = distmatrix[j];
                int n3 = js;
                fArray[n3] = fArray[n3] / (float)sum;
            }
            for (j = is + 1; j < n; ++j) {
                distmatrix[j][js] = distmatrix[j][is] * (float)number[is] + distmatrix[j][js] * (float)number[js];
                float[] fArray = distmatrix[j];
                int n4 = js;
                fArray[n4] = fArray[n4] / (float)sum;
            }
            for (j = 0; j < is; ++j) {
                distmatrix[is][j] = distmatrix[n - 1][j];
            }
            for (j = is + 1; j < n - 1; ++j) {
                distmatrix[j][is] = distmatrix[n - 1][j];
            }
            number[js] = sum;
            number[is] = number[n - 1];
            clusterid[js] = n - nelements - 1;
            clusterid[is] = clusterid[n - 1];
        }
        return result;
    }
}

