/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics;

import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.matrix.Dataset;

public class Kendall
implements DistanceFunction {
    @Override
    public float evaluate(Dataset data1, Dataset data2, float[] weight, int index1, int index2) {
        int con = 0;
        int dis = 0;
        int exx = 0;
        int exy = 0;
        boolean flag = false;
        int n = data1.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (Float.isNaN(data1.getValue(index1, i)) || Float.isNaN(data2.getValue(index2, i))) continue;
            for (int j = 0; j < i; ++j) {
                if (Float.isNaN(data1.getValue(index1, j)) || Float.isNaN(data2.getValue(index2, j))) continue;
                float x1 = data1.getValue(index1, i);
                float x2 = data1.getValue(index1, j);
                float y1 = data2.getValue(index2, i);
                float y2 = data2.getValue(index2, j);
                if (x1 < x2 && y1 < y2) {
                    ++con;
                }
                if (x1 > x2 && y1 > y2) {
                    ++con;
                }
                if (x1 < x2 && y1 > y2) {
                    ++dis;
                }
                if (x1 > x2 && y1 < y2) {
                    ++dis;
                }
                if (x1 == x2 && y1 != y2) {
                    ++exx;
                }
                if (x1 != x2 && y1 == y2) {
                    ++exy;
                }
                flag = true;
            }
        }
        if (!flag) {
            return 0.0f;
        }
        float denomx = con + dis + exx;
        float denomy = con + dis + exy;
        if (denomx == 0.0f) {
            return 1.0f;
        }
        if (denomy == 0.0f) {
            return 1.0f;
        }
        float tau = (float)((double)(con - dis) / Math.sqrt(denomx * denomy));
        return 1.0f - tau;
    }

    public String toString() {
        return "Kendall's tau";
    }

    public boolean isScaleToOne() {
        return false;
    }
}

