/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.som;

import org.broadinstitute.genee.clustering.cc.AbstractMevClusterer;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.util.FloatMatrix;

public class SOMClusterer
extends AbstractMevClusterer {
    public static final int BUBBLE_NEIGHBORHOOD = 0;
    public static final int GAUSSIAN_NEIGHBORHOOD = 1;
    private int neighbordhood = 1;
    public static final int HEXAGONAL_TOPOLOGY = 0;
    public static final int RECTANGULAR_TOPOLOGY = 1;
    private int topology = 0;
    public static final int INIT_VECTOR = 0;
    public static final int INIT_GENES = 1;
    private int initialization = 1;
    private float alpha = 0.05f;
    private float radius = 3.0f;

    @Override
    public void execute() {
        AlgorithmData data = new AlgorithmData();
        int max_r = (int)Math.sqrt(this.k);
        while ((float)(this.k / max_r) != (float)this.k / (float)max_r) {
            --max_r;
        }
        int maxRows = max_r;
        for (int numRows = 1; numRows <= maxRows; ++numRows) {
            int numCols = this.k / numRows;
            if (numCols != this.k / numRows) continue;
            data.addMatrix("experiment", this.matrix);
            data.addParam("distance-factor", String.valueOf(1.0f));
            data.addParam("distance-absolute", String.valueOf(false));
            data.addParam("distance-function", String.valueOf(this.distanceFunction));
            data.addParam("dimension-x", String.valueOf(numCols));
            data.addParam("dimension-y", String.valueOf(numRows));
            data.addParam("iterations", String.valueOf(this.iterations));
            data.addParam("topology", this.topology == 0 ? "hexagonal" : "rectangular");
            data.addParam("is_neighborhood_bubble", String.valueOf(this.neighbordhood == 0));
            data.addParam("is_random_vector", String.valueOf(this.initialization == 0));
            data.addParam("radius", String.valueOf(this.radius));
            data.addParam("alpha", String.valueOf(this.alpha));
            data.addParam("som-cluster-genes", String.valueOf(true));
            AlgorithmData result = null;
            result.getMatrix("clusters_means");
            FloatMatrix variances = result.getMatrix("clusters_variances");
            Cluster result_cluster = result.getCluster("cluster");
            this.nodeList = result_cluster.getNodeList();
        }
    }
}

