/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.rankedlist;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.GENEEWindowNotifier;
import org.broadinstitute.genee.category.VectorVisualMapperEvent;
import org.broadinstitute.genee.category.VectorVisualMapperListener;
import org.broadinstitute.genee.cmap.rankedlist.RankedListController;
import org.broadinstitute.genee.cmap.rankedlist.RankedListToolBar;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.heatmap.SelectionEvent;
import org.broadinstitute.genee.heatmap.SelectionListener;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.rankedlist.DatasetRankedList;
import org.broadinstitute.genee.matrix.rankedlist.DefaultRankedListCollection;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;

public class RankedListAction
extends AbstractAction {
    public RankedListAction(HeatMapPanel heatMapPanel) {
        super("Ranked List");
        this.putValue("ShortDescription", "Ranked list");
        this.putValue("SmallIcon", IconManager.loadIcon("16x16/rankedlist.png"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new ShowNewRankedListView();
    }

    private static class ShowNewRankedListView {
        private Project project = Application.getProject();
        private RankedListController rankedListController;

        private ShowNewRankedListView() {
            RankedList prototypeRankedList;
            int[] columnSelection = this.project.getModelColumnIndices(true, false);
            Dataset dataset = DatasetUtil.sliceView(this.project.getOriginalDataset(), null, columnSelection);
            RankedList[] rankedLists = new RankedList[dataset.getColumnCount()];
            String labelBy = null;
            MetadataModel textColumns = MetadataUtil.getTextColumns(dataset.getColumnMetadata());
            if (textColumns.getMetadataCount() > 0) {
                labelBy = textColumns.get(0).getName();
            } else if (dataset.getColumnMetadata().getMetadataCount() > 0) {
                labelBy = dataset.getColumnMetadata().getColumnName(0);
            }
            try {
                for (int j = 0; j < rankedLists.length; ++j) {
                    rankedLists[j] = new DatasetRankedList(dataset, j, labelBy);
                }
            }
            catch (IllegalArgumentException x) {
                UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), x.getMessage());
                return;
            }
            if (rankedLists.length > 0) {
                prototypeRankedList = rankedLists[0];
            } else {
                try {
                    prototypeRankedList = new DatasetRankedList(DatasetUtil.sliceView(this.project.getOriginalDataset(), null, new int[]{0}), 0, labelBy);
                }
                catch (IllegalArgumentException x) {
                    UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), x.getMessage());
                    return;
                }
            }
            final SelectionListener selectionListener = new SelectionListener(){

                @Override
                public void valueChanged(SelectionEvent e) {
                    ShowNewRankedListView.this.syncSelection();
                }
            };
            final ProjectListener projectListener = new ProjectListener(){

                @Override
                public void projectChanged(ProjectEvent e) {
                    if (e.isRowChanged() || e.isColumnChanged()) {
                        ShowNewRankedListView.this.rankedListController.getRankedListCollection().notifyListeners();
                    }
                }
            };
            final VectorVisualMapperListener colorModelListener = new VectorVisualMapperListener(){

                @Override
                public void mappingChanged(VectorVisualMapperEvent e) {
                    ShowNewRankedListView.this.rankedListController.getRankedListCollection().notifyListeners();
                }
            };
            this.rankedListController = new RankedListController(new DefaultRankedListCollection(dataset.getColumnMetadata(), this.project.getColumnColorModel(), this.project.getRowColorModel(), rankedLists), prototypeRankedList, MetadataUtil.getNames(dataset.getColumnMetadata()), labelBy);
            this.rankedListController.getRankedListCollection().notifyListeners();
            this.project.addColumnSelectionListener(selectionListener);
            GENEEWindow window = Application.createViewWindow("Ranked List", new GENEEWindowNotifier(){

                @Override
                public void notifyHidden() {
                    ShowNewRankedListView.this.project.removeColumnSelectionListener(selectionListener);
                    ShowNewRankedListView.this.project.removeProjectListener(projectListener);
                    ShowNewRankedListView.this.project.getRowColorModel().removeVectorVisualMapperListener(colorModelListener);
                    ShowNewRankedListView.this.rankedListController.dispose();
                }

                @Override
                public void notifyShowing() {
                    ShowNewRankedListView.this.project.addColumnSelectionListener(selectionListener);
                    ShowNewRankedListView.this.project.addProjectListener(projectListener);
                    ShowNewRankedListView.this.project.getRowColorModel().addVectorVisualMapperListener(colorModelListener);
                }
            });
            window.getContentPane().add(this.rankedListController.getComponent());
            window.getContentPane().add((Component)new RankedListToolBar(this.rankedListController), "North");
            window.pack();
            window.setSize(window.getWidth(), window.getHeight() + 20);
            UIUtil.sizeToScreen(window);
            window.setVisible(true);
        }

        private void syncSelection() {
            if (this.rankedListController.isSyncSelection()) {
                Dataset dataset = this.project.getOriginalDataset();
                int[] columnSelection = this.project.getModelColumnIndices(true, false);
                dataset = DatasetUtil.sliceView(dataset, null, (int[])(columnSelection != null && columnSelection.length == 0 ? null : columnSelection));
                RankedList[] rankedLists = new RankedList[dataset.getColumnCount()];
                for (int j = 0; j < rankedLists.length; ++j) {
                    rankedLists[j] = new DatasetRankedList(dataset, j, this.rankedListController.getLabelBy());
                }
                this.rankedListController.getRankedListCollection().setRankedLists(rankedLists, dataset.getColumnMetadata());
            }
        }
    }
}

