/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.rankedlist;

import chemaxon.struc.Molecule;
import com.google.common.base.Function;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.cmap.rankedlist.ATCRankedListFilterUI;
import org.broadinstitute.genee.cmap.rankedlist.IdSupplier;
import org.broadinstitute.genee.filter.AdvancedFilterUI;
import org.broadinstitute.genee.filter.CheckBoxListFilterUI;
import org.broadinstitute.genee.filter.FilterUI;
import org.broadinstitute.genee.filter.GeneSetFilterUI;
import org.broadinstitute.genee.filter.NumberFilterUI;
import org.broadinstitute.genee.filter.RankedListFilterableAttribute;
import org.broadinstitute.genee.filter.TanimotoFilterComponent;
import org.broadinstitute.genee.gui.TransferableObject;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.dnd.DragHelper;
import org.broadinstitute.genee.gui.dnd.PatchedTransferHandler;
import org.broadinstitute.genee.io.matrix.geneset.GeneSet;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.AbstractVector;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;

public class RankedListMetadataDragComponent {
    private JPanel availableAttributes;

    public RankedListMetadataDragComponent(RankedList rankedList, RankedListFilterableAttribute[] attributes) {
        this.availableAttributes = new JPanel((LayoutManager)new FormLayout("p", UIUtil.createRowStringForFormLayout(attributes.length)));
        CellConstraints cc = new CellConstraints();
        int i = 0;
        int row = 1;
        while (i < attributes.length) {
            this.availableAttributes.add((Component)this.createDraggableAttribute(attributes[i]), cc.xy(1, row));
            ++i;
            row += 2;
        }
        this.availableAttributes.setMinimumSize(new Dimension());
    }

    public JComponent getComponent() {
        return this.availableAttributes;
    }

    private JComponent createDraggableAttribute(final RankedListFilterableAttribute rla) {
        JLabel c = new JLabel(rla.toString());
        new DragHelper(c, new PatchedTransferHandler(){

            @Override
            protected Transferable createTransferable(JComponent c) {
                return new TransferableObject<RankedListFilterableAttribute>(rla);
            }
        }, 2);
        return c;
    }

    public static List<RankedListAttribute> createAttributes(RankedList rl) {
        ArrayList<RankedListAttribute> results = new ArrayList<RankedListAttribute>();
        int ncols = rl.getMetadata().getMetadataCount();
        for (int j = 0; j < ncols; ++j) {
            RankedListAttribute attr = RankedListMetadataDragComponent.createRankedListAttribute(rl.getMetadata().get(j), rl);
            if (attr == null) continue;
            results.add(attr);
        }
        return results;
    }

    public static RankedListAttribute createRankedListAttribute(Vector vector, RankedList rl) {
        if (Number.class.isAssignableFrom(vector.getColumnClass())) {
            return new NumberAttribute(vector.getName(), new RankedListIdSupplier(vector, rl), VectorUtil.getMin(vector), VectorUtil.getMax(vector));
        }
        if (String.class.isAssignableFrom(vector.getColumnClass())) {
            Set set = VectorUtil.getValues(vector);
            ArrayList list = new ArrayList(set);
            Collections.sort(list, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    if (s1 == null) {
                        return -1;
                    }
                    if (s2 == null) {
                        return 1;
                    }
                    return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
                }
            });
            return new CheckBoxListAttribute(vector.getName(), new RankedListIdSupplier(vector, rl), set, false);
        }
        if (Molecule.class.isAssignableFrom(vector.getColumnClass())) {
            return new TanimotoAttribute(rl, new RankedListIdSupplier(vector, rl));
        }
        System.out.println("Unsupported class: " + vector.getColumnClass());
        return null;
    }

    private static class RankedListIdSupplier
    implements IdSupplier {
        private Vector vector;
        private RankedList rankedList;

        private RankedListIdSupplier(Vector vector, RankedList rankedList) {
            this.vector = vector;
            this.rankedList = rankedList;
        }

        @Override
        public Object get(Object id) {
            return this.getValue(this.rankedList.getIndex(id));
        }

        @Override
        public Class<?> getColumnClass() {
            return this.vector.getColumnClass();
        }

        @Override
        public Comparator<Object> getComparator() {
            return this.vector.getComparator();
        }

        @Override
        public String getName() {
            return this.vector.getName();
        }

        @Override
        public Object getProperty(Object key) {
            return this.vector.getProperty(key);
        }

        @Override
        public Collection<Object> getPropertyKeys() {
            return this.vector.getPropertyKeys();
        }

        @Override
        public Object getValue(int index) {
            return this.vector.getValue(index);
        }

        @Override
        public void setColumnClass(Class<?> columnClass) {
            this.vector.setColumnClass(columnClass);
        }

        @Override
        public void setComparator(Comparator<Object> comparator) {
            this.vector.setComparator(comparator);
        }

        @Override
        public void setProperty(Object key, Object value) {
            this.vector.setProperty(key, value);
        }

        @Override
        public void setValue(int index, Object value) {
            this.vector.setValue(index, value);
        }

        @Override
        public int size() {
            return this.vector.size();
        }
    }

    public static class TanimotoAttribute
    implements RankedListAttribute {
        private Vector compoundNameProvider;
        private IdSupplier moleculeProvider;

        private TanimotoAttribute(RankedList rankedList, IdSupplier moleculeProvider) {
            this.moleculeProvider = moleculeProvider;
            int pertubagenNameMetadataIndex = -1;
            int cols = rankedList.getMetadata().getMetadataCount();
            for (int j = 0; j < cols; ++j) {
                if (!"name".equalsIgnoreCase(rankedList.getMetadata().get(j).getName())) continue;
                pertubagenNameMetadataIndex = j;
            }
            if (pertubagenNameMetadataIndex == -1) {
                throw new IllegalArgumentException("No name metadata column found.");
            }
            this.compoundNameProvider = rankedList.getMetadata().get(pertubagenNameMetadataIndex);
        }

        @Override
        public FilterUI createFilterUI() {
            return new TanimotoFilterComponent(this.compoundNameProvider, this.moleculeProvider);
        }

        @Override
        public IdSupplier getFilterValuesSupplier() {
            return this.moleculeProvider;
        }

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public String toString() {
            return "Compound Structure";
        }
    }

    public static interface RankedListAttribute
    extends RankedListFilterableAttribute {
        public boolean isNumber();

        public String toString();
    }

    public static class NumberAttribute
    implements RankedListAttribute {
        private String name;
        private IdSupplier supplier;
        private float min;
        private float max;

        public NumberAttribute(String name, IdSupplier supplier, float min, float max) {
            this.min = min;
            this.max = max;
            this.name = name;
            this.supplier = supplier;
        }

        @Override
        public FilterUI createFilterUI() {
            return new NumberFilterUI(this.name, this.min, this.max);
        }

        @Override
        public IdSupplier getFilterValuesSupplier() {
            return this.supplier;
        }

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    public static class GeneSetQueryAttribute
    implements RankedListAttribute {
        private IdSupplier supplier;
        private Collection<GeneSet> sets;
        private Function<String, Object> stringConverter;

        public GeneSetQueryAttribute(IdSupplier supplier, Collection<GeneSet> sets) {
            this.supplier = supplier;
            this.sets = sets;
            this.stringConverter = new Function<String, Object>(){

                public Object apply(String token) {
                    return token;
                }
            };
        }

        @Override
        public FilterUI createFilterUI() {
            return new GeneSetFilterUI("Gene Set", this.sets, this.stringConverter);
        }

        @Override
        public IdSupplier getFilterValuesSupplier() {
            return this.supplier;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public String toString() {
            return "Gene Set";
        }
    }

    public static class CheckBoxListAttribute
    implements RankedListAttribute {
        private boolean isNumber;
        private String name;
        private IdSupplier supplier;
        private Set values;
        private Function<String, Object> stringConverter;

        public CheckBoxListAttribute(String name, IdSupplier supplier, Set values, boolean isNumber) {
            this.values = values;
            this.name = name;
            this.supplier = supplier;
            this.isNumber = isNumber;
            this.stringConverter = !isNumber ? new Function<String, Object>(){

                public Object apply(String token) {
                    return token;
                }
            } : new Function<String, Object>(){

                public Object apply(String token) {
                    try {
                        return Float.valueOf(ParserHelper.parseFloat(token));
                    }
                    catch (Exception x) {
                        return Float.valueOf(Float.NaN);
                    }
                }
            };
        }

        @Override
        public FilterUI createFilterUI() {
            return new CheckBoxListFilterUI(this.name, this.values, this.stringConverter);
        }

        @Override
        public IdSupplier getFilterValuesSupplier() {
            return this.supplier;
        }

        @Override
        public boolean isNumber() {
            return this.isNumber;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    public static class ATCCodeAttribute
    implements RankedListAttribute {
        private Set<String> atcCodes;
        private IdSupplier supplier;

        public ATCCodeAttribute(Set<String> atcCodes, IdSupplier supplier) {
            this.atcCodes = atcCodes;
            this.supplier = supplier;
        }

        @Override
        public FilterUI createFilterUI() {
            return new ATCRankedListFilterUI(this.atcCodes);
        }

        @Override
        public IdSupplier getFilterValuesSupplier() {
            return this.supplier;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public String toString() {
            return "ATC Code";
        }
    }

    public static class AdvancedQueryAttribute
    implements RankedListFilterableAttribute {
        private String name;
        private RankedList rankedList;

        public AdvancedQueryAttribute(String name, RankedList rankedList) {
            this.name = name;
            this.rankedList = rankedList;
        }

        @Override
        public FilterUI createFilterUI() {
            return new AdvancedFilterUI(this.name, this.rankedList);
        }

        @Override
        public IdSupplier getFilterValuesSupplier() {
            return new NullIdSupplier(this.name, String.class, this.rankedList.size());
        }

        public String toString() {
            return this.name;
        }
    }

    private static class NullIdSupplier
    extends AbstractVector
    implements IdSupplier {
        private int size;

        public NullIdSupplier(String columnName, Class<?> c, int size) {
            super(columnName, c);
            this.size = size;
        }

        @Override
        public Object getValue(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValue(int index, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Object get(Object id) {
            throw new UnsupportedOperationException();
        }
    }
}

