/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.rankedlist;

import chemaxon.struc.Molecule;
import javax.swing.table.AbstractTableModel;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;

class RankedListTableModel
extends AbstractTableModel {
    static final int METADATA_OFFSET = 2;
    private RankedList fullRankedList;
    private RankedList visibleRankedList;
    private MetadataModel metadata;

    RankedListTableModel() {
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Integer.class;
        }
        if (columnIndex == 1) {
            return Float.class;
        }
        return this.metadata.get(columnIndex - 2).getColumnClass();
    }

    @Override
    public int getColumnCount() {
        return this.visibleRankedList != null ? this.metadata.getMetadataCount() + 2 : 0;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Rank";
        }
        if (columnIndex == 1) {
            return "Score";
        }
        return this.metadata.get(columnIndex - 2).getName();
    }

    public RankedList getFullRankedList() {
        return this.fullRankedList;
    }

    @Override
    public int getRowCount() {
        return this.visibleRankedList != null ? this.visibleRankedList.size() : 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return 1 + this.fullRankedList.getIndex(this.visibleRankedList.getId(rowIndex));
        }
        if (columnIndex == 1) {
            return Float.valueOf(this.visibleRankedList.getScore(rowIndex));
        }
        return this.metadata.getValue(rowIndex, columnIndex - 2);
    }

    public RankedList getVisibleRankedList() {
        return this.visibleRankedList;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.getColumnClass(columnIndex).isAssignableFrom(Molecule.class);
    }

    public void setRankedList(RankedList visibleRankedList, RankedList fullRankedList) {
        this.visibleRankedList = visibleRankedList;
        this.fullRankedList = fullRankedList;
        this.updateTextMetadata();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    MetadataModel getMetadata() {
        return this.metadata;
    }

    void updateTextMetadata() {
        this.metadata = this.visibleRankedList == null ? null : MetadataUtil.filter(this.visibleRankedList.getMetadata(), "Text Visible");
        this.fireTableStructureChanged();
    }
}

