/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmdline;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.io.matrix.gctx.GctxReader;
import org.broadinstitute.genee.io.matrix.geneset.GeneSetIO;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class CmdLineUtil {
    private CmdLineUtil() {
    }

    public static List<String> getIds(List<String> ids) throws IOException {
        if (ids.size() == 1 && new File(ids.get(0)).exists()) {
            ids = new ArrayList<String>(GeneSetIO.readGeneSetMatrix(ids.get(0)).get(0).getMembers());
        }
        return ids;
    }

    public static final int[] getIndicesForValues(Vector vector, List<?> values) {
        if (values == null || values.size() == 0) {
            return null;
        }
        Map valueToIndex = VectorUtil.createValueToIndexMap(vector);
        int[] indices = new int[values.size()];
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            Object value = values.get(i);
            Integer index = valueToIndex.get(value);
            if (index == null) {
                System.err.println(value + " not found.");
                System.exit(1);
            }
            indices[i] = index;
        }
        return indices;
    }

    public static Dataset read(String file, List<String> rowIds, List<String> columnIds) throws Exception {
        if (file.toLowerCase().endsWith(".gct")) {
            if (rowIds != null && rowIds.size() > 0 || columnIds != null && columnIds.size() > 0) {
                throw new RuntimeException("Ids not supported for gct files");
            }
            return ProjectIO.readProject(file).getOriginalDataset();
        }
        int[] rowIndices = null;
        GctxReader reader = new GctxReader(file);
        if (rowIds != null) {
            if (rowIds.size() == 1 && new File(rowIds.get(0)).exists()) {
                rowIds = new ArrayList<String>(GeneSetIO.readGeneSetMatrix(rowIds.get(0)).get(0).getMembers());
            }
            Vector ids = reader.getRowsOrColumns(true).get("id");
            rowIndices = CmdLineUtil.getIndicesForValues(ids, rowIds);
        }
        int[] columnIndices = null;
        if (columnIds != null) {
            if (columnIds.size() == 1 && new File(columnIds.get(0)).exists()) {
                columnIds = new ArrayList<String>(GeneSetIO.readGeneSetMatrix(columnIds.get(0)).get(0).getMembers());
            }
            Vector ids = reader.getRowsOrColumns(false).get("id");
            columnIndices = CmdLineUtil.getIndicesForValues(ids, columnIds);
        }
        Dataset dataset = reader.read(rowIndices, columnIndices, true, true, false);
        reader.close();
        return dataset;
    }

    public static String toComparisonString(List<String> aIds, List<String> bIds) {
        int i;
        StringBuilder comparison = new StringBuilder();
        comparison.append("[");
        for (i = 0; i < aIds.size(); ++i) {
            if (i > 0) {
                comparison.append(",");
            }
            comparison.append(i);
        }
        comparison.append("] ");
        comparison.append("[");
        for (i = 0; i < bIds.size(); ++i) {
            if (i > 0) {
                comparison.append(",");
            }
            comparison.append(i + aIds.size());
        }
        comparison.append("]");
        return comparison.toString();
    }
}

