/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound.painter;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.broadinstitute.genee.compound.painter.ImageLayoutChooser;
import org.broadinstitute.genee.compound.painter.ImageTypePanel;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.Dataset;

abstract class AbstractLayoutPanel
extends JPanel {
    protected Map<JCheckBox, ImageTypePanel> imageTypeCheckBoxToImageTypePanel;
    private List<AbstractButton> buttons;
    protected String metadataField;
    private List<ImageTypePanel> imageTypePanels;
    private DefaultProject project;

    public AbstractLayoutPanel(HeatMapPanel heatMapPanel, DefaultProject project, List<ImageTypePanel> imageTypePanels, String metadataField) {
        this.metadataField = metadataField;
        this.imageTypePanels = imageTypePanels;
        this.project = project;
    }

    public void init() {
        TreeSet<String> wellNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (ImageTypePanel imageTypePanel : this.imageTypePanels) {
            Map<Comparable, List<File>> valueToFiles = imageTypePanel.getMetadataNameToValueToFiles().get(this.metadataField);
            if (valueToFiles == null) continue;
            for (Comparable value : valueToFiles.keySet()) {
                wellNames.add(Formatter.toString(value));
            }
        }
        JPanel checkBoxPanel = new JPanel((LayoutManager)new FormLayout(UIUtil.createColumnStringForFormLayout(2), UIUtil.createRowStringForFormLayout(Math.max(wellNames.size(), this.imageTypePanels.size()) + 2)));
        if (wellNames.size() > 1) {
            this.buttons = ImageLayoutChooser.createButtons(checkBoxPanel, 1, this.metadataField, wellNames, false);
        }
        if (this.imageTypePanels.size() > 1) {
            this.imageTypeCheckBoxToImageTypePanel = ImageLayoutChooser.createImageTypeCheckBoxes(checkBoxPanel, 3, this.imageTypePanels);
        } else {
            this.imageTypeCheckBoxToImageTypePanel = new HashMap<JCheckBox, ImageTypePanel>();
            JCheckBox cb = new JCheckBox("", true);
            this.imageTypeCheckBoxToImageTypePanel.put(cb, this.imageTypePanels.get(0));
        }
        this.setLayout(new BorderLayout());
        JButton showHeatMapButton = new JButton("Show Heat Map");
        showHeatMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = null;
                if (AbstractLayoutPanel.this.buttons != null) {
                    for (AbstractButton cb : AbstractLayoutPanel.this.buttons) {
                        if (!cb.isSelected()) continue;
                        value = cb.getText();
                        break;
                    }
                }
                final ArrayList<JCheckBox> selectedImageTypeCheckBoxes = new ArrayList<JCheckBox>();
                for (JCheckBox cb : AbstractLayoutPanel.this.imageTypeCheckBoxToImageTypePanel.keySet()) {
                    if (!cb.isSelected()) continue;
                    selectedImageTypeCheckBoxes.add(cb);
                }
                final String _value = value;
                new BackgroundTask<Dataset>("Creating heat map"){

                    @Override
                    protected void succeeded(Dataset dataset) {
                        AbstractLayoutPanel.this.project.setColumnSortOrder(null);
                        AbstractLayoutPanel.this.project.setDataset(dataset);
                    }

                    @Override
                    protected Dataset doInBackground() throws Exception {
                        return AbstractLayoutPanel.this.createDataset(_value, selectedImageTypeCheckBoxes);
                    }
                }.execute();
            }
        });
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add(this.buildUI());
        southPanel.add((Component)ButtonBarFactory.buildRightAlignedBar((JButton)showHeatMapButton), "South");
        this.add(UIUtil.createNoBorderScrollPane(checkBoxPanel));
        this.add((Component)southPanel, "South");
    }

    protected abstract JComponent buildUI();

    protected abstract Dataset createDataset(String var1, List<JCheckBox> var2);
}

