/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound.painter;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.broadinstitute.genee.compound.painter.AbstractLayoutPanel;
import org.broadinstitute.genee.compound.painter.ImageElement;
import org.broadinstitute.genee.compound.painter.ImageTypePanel;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.io.util.PlateUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

class PlateLayoutPanel
extends AbstractLayoutPanel {
    private JTextField numberOfColumnsTextField;
    private JTextField numberOfRowsTextField;

    public PlateLayoutPanel(HeatMapPanel heatMapPanel, DefaultProject project, List<ImageTypePanel> imageTypePanels) {
        super(heatMapPanel, project, imageTypePanels, "Plate");
        super.init();
    }

    @Override
    protected JComponent buildUI() {
        FormBuilder p = new FormBuilder();
        p.nextRow();
        p.addSeparator("Plate Format");
        p.addLabel("Number of columns:");
        this.numberOfColumnsTextField = new JTextField("24", 10);
        p.add(this.numberOfColumnsTextField);
        p.nextRow();
        p.addLabel("Number of rows:");
        this.numberOfRowsTextField = new JTextField("16", 10);
        p.add(this.numberOfRowsTextField);
        return p.getPanel();
    }

    @Override
    protected Dataset createDataset(String value, List<JCheckBox> selectedImageTypeCheckBoxes) {
        RowMajorArray2DDataset dataset = new RowMajorArray2DDataset("", Integer.parseInt(this.numberOfRowsTextField.getText().trim()), Integer.parseInt(this.numberOfColumnsTextField.getText().trim()));
        int seriesIndex = dataset.addSeries("Image", ImageElement.class);
        int rows = dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            int cols = dataset.getColumnCount();
            for (int j = 0; j < cols; ++j) {
                dataset.setObjectValue(i, j, new ImageElement(), seriesIndex);
            }
        }
        Vector plateRowVector = MetadataUtil.addRowVector(dataset.getRowMetadata(), "plate row", String.class);
        int rows2 = dataset.getRowCount();
        for (int i = 0; i < rows2; ++i) {
            plateRowVector.setValue(i, String.valueOf(PlateUtil.convertRowIndexToChar(i)));
        }
        for (JCheckBox cb : selectedImageTypeCheckBoxes) {
            List<File> imageFiles;
            ImageTypePanel imageTypePanel = (ImageTypePanel)this.imageTypeCheckBoxToImageTypePanel.get(cb);
            Map<Comparable, List<File>> valueToFiles = imageTypePanel.getMetadataNameToValueToFiles().get(this.metadataField);
            List<File> list = imageFiles = valueToFiles != null ? valueToFiles.get(value) : null;
            if (imageFiles == null) {
                imageFiles = Arrays.asList(imageTypePanel.getImageFiles());
            }
            for (File file : imageFiles) {
                int column;
                int row;
                String well = imageTypePanel.getWell(file);
                if (well == null) {
                    System.out.println("well is null for " + file);
                    continue;
                }
                try {
                    row = PlateUtil.convertWellRowToInt(String.valueOf(well.charAt(0)));
                    column = Integer.parseInt(well.substring(1)) - 1;
                }
                catch (Exception x) {
                    int n = Integer.parseInt(well) - 1;
                    row = n / dataset.getColumnCount();
                    column = n % dataset.getColumnCount() - 1;
                }
                ImageElement imageElement2 = (ImageElement)dataset.getObjectValue(row, column, seriesIndex);
                imageElement2.add(Arrays.asList(file));
            }
        }
        return dataset;
    }
}

