/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import javax.swing.event.EventListenerList;
import org.broadinstitute.genee.application.UniqueEventListenerList;
import org.broadinstitute.genee.filter.Filter;
import org.broadinstitute.genee.heatmap.FilterEvent;
import org.broadinstitute.genee.heatmap.FilterListener;

public abstract class AbstractFilter
implements Filter {
    protected EventListenerList listenerList = new UniqueEventListenerList();
    protected boolean enabled = true;

    @Override
    public void addFilterListener(FilterListener l) {
        this.listenerList.add(FilterListener.class, l);
    }

    public void fireFilterChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        FilterEvent e = new FilterEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != FilterListener.class) continue;
            ((FilterListener)listeners[i + 1]).filterChanged(e);
        }
    }

    @Override
    public FilterListener[] getFilterListeners() {
        return (FilterListener[])this.listenerList.getListeners(FilterListener.class);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void removeFilterListener(FilterListener l) {
        this.listenerList.remove(FilterListener.class, l);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.fireFilterChanged();
    }
}

