/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import gnu.trove.set.hash.TIntHashSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import org.broadinstitute.genee.filter.FilterUI;
import org.broadinstitute.genee.filter.IndexedFilter;
import org.broadinstitute.genee.gui.ActionListenerHelper;
import org.broadinstitute.genee.gui.DatasetAutocomplete;
import org.broadinstitute.genee.gui.DelimListDataIntelliHints;
import org.broadinstitute.genee.heatmap.AbstractIndexedQuickSearch;
import org.broadinstitute.genee.heatmap.LuceneSearchParser;
import org.broadinstitute.genee.heatmap.QuickRowSearch;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;

public class AdvancedFilterUI<T>
implements FilterUI {
    private String filterName;
    private RankedListQuickSearch rankedListQuickSearch;

    public AdvancedFilterUI(String filterName, RankedList rankedList) {
        this.filterName = filterName;
        this.rankedListQuickSearch = new RankedListQuickSearch(rankedList);
    }

    @Override
    public IndexedFilter apply() {
        return new AdvancedIndexedFilter(new TIntHashSet(this.rankedListQuickSearch.matches));
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getFilterName() {
        return this.filterName;
    }

    @Override
    public Component getUserInterfaceComponent() {
        return this.rankedListQuickSearch.getComponent();
    }

    private static class RankedListQuickSearch
    extends AbstractIndexedQuickSearch {
        private RankedList rankedList;
        private int[] matches;

        public RankedListQuickSearch(final RankedList rankedList) {
            super(false);
            this.rankedList = rankedList;
            new DelimListDataIntelliHints(this.getTextField()){

                @Override
                public Collection<String> getMatches(String text) {
                    boolean caseSensitive = this.isCaseSensitive();
                    String filterColumnName = RankedListQuickSearch.this.getDefaultFilterColumnName();
                    MetadataModel metadata = rankedList.getMetadata();
                    return DatasetAutocomplete.getMatches(text, metadata, caseSensitive, filterColumnName);
                }
            };
        }

        @Override
        protected String getSavedSearchKey() {
            return "heat.map.rows.saved.search";
        }

        @Override
        protected LuceneSearchParser.SearchPredicateAdapterCreator createSearchPredicateAdapterCreator() {
            return new LuceneSearchParser.SearchPredicateAdapterCreator(){

                @Override
                public LuceneSearchParser.IndexedSearchPredicate create(LuceneSearchParser.InternalSearchPredicate internalSearchPredicate) {
                    return new LuceneSearchParser.RankedListSearchPredicateAdapter(internalSearchPredicate);
                }
            };
        }

        @Override
        protected Collection<String> getAvailableFieldNames() {
            ArrayList<String> filterColumnNames = new ArrayList<String>();
            int count = this.rankedList.getMetadata().getMetadataCount();
            for (int i = 0; i < count; ++i) {
                filterColumnNames.add(this.rankedList.getMetadata().get(i).getName());
            }
            return filterColumnNames;
        }

        @Override
        protected final void notifyFilterChanged() {
            if (this.searchPredicate == null) {
                this.clearLabelText();
            } else {
                this.searchPredicate.setData(this.rankedList);
                this.matches = QuickRowSearch.getMatches(this.searchPredicate, this.rankedList.size());
                this.setLabelText(this.matches.length, this.rankedList.size());
            }
            ActionListenerHelper.fireActionPerformed(this.listenerList, new ActionEvent((Object)this, 1001, null));
        }
    }

    private static class AdvancedIndexedFilter
    implements IndexedFilter {
        private TIntHashSet set;

        public AdvancedIndexedFilter(TIntHashSet set) {
            this.set = set;
        }

        @Override
        public boolean accept(int index) {
            return this.set.contains(index);
        }

        @Override
        public void setValueProvider(Vector filterValueProvider) {
        }
    }
}

