/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.filter.FilterResultsCollector;
import org.broadinstitute.genee.filter.FilterUI;
import org.broadinstitute.genee.filter.IndexedFilter;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.matrix.Vector;

public class FilterDialog {
    protected FilterResultsCollector filterResultsCollector;
    private GENEEWindow dialog;
    private FilterUI filterUI;
    private Vector filterValueSupplier;

    public FilterDialog(Container parent, final FilterUI filterUI, Vector filterValueSupplier, FilterResultsCollector filterResultsCollector) {
        this.filterValueSupplier = filterValueSupplier;
        this.filterResultsCollector = filterResultsCollector;
        this.filterUI = filterUI;
        this.dialog = Application.createDialog(parent, filterUI.getFilterName());
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        JButton applyBtn = new JButton("Apply");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterDialog.this.apply();
                FilterDialog.this.dialog.setVisible(false);
            }
        });
        applyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterDialog.this.apply();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                filterUI.cancel();
                FilterDialog.this.dialog.setVisible(false);
            }
        });
        this.dialog.getContentPane().add(filterUI.getUserInterfaceComponent());
        this.dialog.getContentPane().add((Component)UIUtil.buildOKCancelApplyBar(okButton, cancelButton, applyBtn), "South");
        this.dialog.getRootPane().setDefaultButton(okButton);
        this.dialog.pack();
    }

    public void apply() {
        IndexedFilter indexedFilter = this.filterUI.apply();
        indexedFilter.setValueProvider(this.filterValueSupplier);
        this.filterResultsCollector.clear();
        int size = this.filterValueSupplier.size();
        for (int i = 0; i < size; ++i) {
            if (!indexedFilter.accept(i)) continue;
            this.filterResultsCollector.add(i);
        }
        this.notifyChanged();
    }

    public void dispose() {
        this.dialog.dispose();
    }

    public FilterUI getFilterUI() {
        return this.filterUI;
    }

    public void show() {
        this.dialog.setVisible(true);
    }

    protected void notifyChanged() {
    }
}

