/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.filter.FilterPanel;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.TrackerUtil;

public class FilterRowsAction
extends AbstractAction {
    private GENEEWindow window;
    private FilterPanel filterPanel;
    private HeatMapPanel heatMapPanel;

    public FilterRowsAction(HeatMapPanel heatMapPanel) {
        super("Filter Rows\u2026");
        this.putValue("SmallIcon", IconManager.loadIcon("16x16/20455.sc_datafilterstandardfilter.png"));
        this.putValue("ShortDescription", "Filter rows");
        this.heatMapPanel = heatMapPanel;
    }

    private void showWindow() {
        if (this.window == null) {
            this.window = Application.createDialog("Filter Rows");
            Project project = this.heatMapPanel.getProject();
            this.filterPanel = new FilterPanel(project, FilterPanel.getDefaultFilterComponentCreators(project.getOriginalDataset().getRowMetadata()));
            this.window.getContentPane().add(this.filterPanel.getComponent(), "Center");
            this.window.pack();
            this.window.setSize(Math.max(300, this.window.getWidth()), 400);
        }
        this.window.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TrackerUtil.trackPageView((String)this.getValue("Name"));
        this.showWindow();
    }
}

