/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import com.google.common.collect.Sets;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.CheckBoxList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.broadinstitute.genee.gui.DelimListDataIntelliHints;
import org.broadinstitute.genee.gui.FilterableListModel;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.GENEEDefaultListCellRenderer;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.QuickListFilter;

public abstract class FilterSelectionComponent {
    private CheckBoxList checkBoxList;
    private JScrollPane enterValuesScrollPane;
    private JTextArea enterValuesTextArea;
    private boolean exclude = false;
    private JCheckBox excludeCheckBox;
    private boolean excludeSavedState;
    private FilterableListModel filterableListModel;
    private JPanel mainPanel;
    private int numberOfItems;
    private QuickListFilter quickFilter;
    private String savedFilterText = "";
    private JPanel selectFromListPanel;
    private JLabel selectionLabel;
    private JComponent visibleComponent;
    private JComboBox inputMethodDropdown;
    private Collection items;
    private boolean savedInputMethodIsCheckBoxList;
    private String savedEnterValuesText;
    private Set selectedItems = new HashSet();

    public FilterSelectionComponent(Collection values) {
        this.items = values;
        this.numberOfItems = this.items.size();
        this.filterableListModel = new FilterableListModel();
        if (this.items != null) {
            this.filterableListModel.setItems(this.items);
        }
        this.checkBoxList = new CheckBoxList((ListModel)((Object)this.filterableListModel));
        this.checkBoxList.setCellRenderer((ListCellRenderer)new GENEEDefaultListCellRenderer());
        this.checkBoxList.selectNone();
        this.selectionLabel = new JLabel(" ");
        if (this.items.size() > 20) {
            this.checkBoxList.setVisibleRowCount(Math.min(20, this.items.size()));
        }
        JButton selectAllButton = new JButton("All");
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterSelectionComponent.this.checkBoxList.selectAll();
            }
        });
        JButton selectNoneButton = new JButton("None");
        selectNoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterSelectionComponent.this.checkBoxList.selectNone();
            }
        });
        JPanel buttonPanel = ButtonBarFactory.buildLeftAlignedBar((JButton[])new JButton[]{selectAllButton, selectNoneButton});
        this.quickFilter = new QuickListFilter((ListSelectionModel)this.checkBoxList.getCheckBoxListSelectionModel(), this.filterableListModel){

            @Override
            protected String getSavedSearchKey() {
                return null;
            }
        };
        new DelimListDataIntelliHints(this.quickFilter.getTextField()){

            @Override
            public Collection<String> getMatches(String text) {
                boolean caseSensitive = this.isCaseSensitive();
                ArrayList<String> matches = new ArrayList<String>();
                for (Object val : FilterSelectionComponent.this.items) {
                    String s;
                    String _val = s = val.toString();
                    if (!caseSensitive) {
                        _val = _val.toLowerCase();
                    }
                    if (!_val.startsWith(text)) continue;
                    matches.add(s);
                }
                Collections.sort(matches);
                return matches;
            }
        };
        this.selectFromListPanel = new JPanel(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        this.checkBoxList.setBackground(this.selectFromListPanel.getBackground());
        this.selectFromListPanel.add((Component)this.quickFilter.getComponent(), "North");
        this.selectFromListPanel.add((Component)UIUtil.createNoBorderScrollPane((Component)this.checkBoxList), "Center");
        JPanel lowerPanel = new JPanel((LayoutManager)new FormLayout("p", "p, 4px, p, 4px, p"));
        lowerPanel.add((Component)buttonPanel, cc.xy(1, 1));
        lowerPanel.add((Component)this.selectionLabel, cc.xy(1, 3));
        this.excludeCheckBox = new JCheckBox("Exclude selection", false);
        lowerPanel.add((Component)this.excludeCheckBox, cc.xy(1, 5));
        this.excludeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterSelectionComponent.this.setExclude(FilterSelectionComponent.this.excludeCheckBox.isSelected());
            }
        });
        this.checkBoxList.getCheckBoxListSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FilterSelectionComponent.this.updateSelectionLabel();
            }
        });
        this.inputMethodDropdown = UIUtil.createComboBox(new String[]{"Select From List", "Enter Values"});
        this.inputMethodDropdown.setSelectedIndex(0);
        this.inputMethodDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterSelectionComponent.this.mainPanel.remove(FilterSelectionComponent.this.visibleComponent);
                if (FilterSelectionComponent.this.inputMethodDropdown.getSelectedIndex() == 0) {
                    FilterSelectionComponent.this.mainPanel.add((Component)FilterSelectionComponent.this.selectFromListPanel, "Center");
                    FilterSelectionComponent.this.visibleComponent = FilterSelectionComponent.this.selectFromListPanel;
                    FilterSelectionComponent.this.excludeCheckBox.setText("Exclude selection");
                } else {
                    FilterSelectionComponent.this.mainPanel.add((Component)FilterSelectionComponent.this.enterValuesScrollPane, "Center");
                    FilterSelectionComponent.this.visibleComponent = FilterSelectionComponent.this.enterValuesScrollPane;
                    FilterSelectionComponent.this.excludeCheckBox.setText("Exclude entered values");
                }
                FilterSelectionComponent.this.mainPanel.revalidate();
                FilterSelectionComponent.this.mainPanel.repaint();
                FilterSelectionComponent.this.visibleComponent.revalidate();
                FilterSelectionComponent.this.visibleComponent.repaint();
                FilterSelectionComponent.this.updateSelectionLabel();
            }
        });
        this.enterValuesTextArea = new JTextArea(20, 80);
        this.enterValuesScrollPane = UIUtil.createNoBorderScrollPane(this.enterValuesTextArea);
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.nextRow();
        formBuilder.addLabel("Values:");
        formBuilder.add(this.inputMethodDropdown);
        formBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)formBuilder.getPanel(), "North");
        this.mainPanel.add((Component)this.selectFromListPanel, "Center");
        this.visibleComponent = this.selectFromListPanel;
        lowerPanel.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
        this.mainPanel.add((Component)lowerPanel, "South");
        this.updateSelectionLabel();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public Set getSelectedItems() {
        if (this.inputMethodDropdown.getSelectedIndex() == 0) {
            return this.selectedItems;
        }
        return this.exclude ? Sets.difference((Set)((Set)(this.items instanceof Set ? this.items : new HashSet(this.items))), (Set)this.getSelectionFromTextArea()) : this.getSelectionFromTextArea();
    }

    public void restoreState() {
        System.out.println("restoreState");
        this.exclude = this.excludeSavedState;
        this.excludeCheckBox.setSelected(this.exclude);
        this.quickFilter.setSearchText(this.savedFilterText);
        this.checkBoxList.setSelectedObjects(this.selectedItems.toArray());
        this.enterValuesTextArea.setText(this.savedEnterValuesText);
    }

    public void saveState() {
        this.selectedItems = this.exclude ? UIUtil.getUnselectedValues((ListSelectionModel)this.checkBoxList.getCheckBoxListSelectionModel(), (ListModel)((Object)this.filterableListModel)) : UIUtil.getSelectedValues((ListSelectionModel)this.checkBoxList.getCheckBoxListSelectionModel(), (ListModel)((Object)this.filterableListModel));
        this.excludeSavedState = this.exclude;
        this.savedFilterText = this.quickFilter.getTextField().getText();
        this.savedEnterValuesText = this.enterValuesTextArea.getText();
        this.savedInputMethodIsCheckBoxList = this.inputMethodDropdown.getSelectedIndex() == 0;
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
        this.updateSelectionLabel();
    }

    public void setSelectedItems(Collection items) {
        this.inputMethodDropdown.setSelectedIndex(0);
        this.excludeCheckBox.setSelected(false);
        this.checkBoxList.getCheckBoxListSelectionModel().setValueIsAdjusting(true);
        this.quickFilter.setSearchText("");
        HashMap<Object, Integer> valueToIndex = new HashMap<Object, Integer>();
        int cc = this.filterableListModel.getSize();
        for (int i = 0; i < cc; ++i) {
            valueToIndex.put(this.filterableListModel.getElementAt(i), i);
        }
        for (Object item : items) {
            Integer index = (Integer)valueToIndex.get(item);
            if (index == null) continue;
            this.checkBoxList.getCheckBoxListSelectionModel().addSelectionInterval(index.intValue(), index.intValue());
        }
        this.checkBoxList.getCheckBoxListSelectionModel().setValueIsAdjusting(false);
    }

    protected abstract Object parseTextAreaLine(String var1);

    private Set getSelectionFromTextArea() {
        String[] tokens;
        HashSet<Object> set = new HashSet<Object>();
        String text = this.enterValuesTextArea.getText();
        for (String token : tokens = text.split("\n")) {
            if ((token = token.trim()).length() <= 0) continue;
            Object obj = this.parseTextAreaLine(token);
            set.add(obj);
        }
        return set;
    }

    private void updateSelectionLabel() {
        if (this.inputMethodDropdown.getSelectedIndex() == 0) {
            this.selectionLabel.setText((this.exclude ? "Excluded " : "Selected ") + this.checkBoxList.getCheckBoxListSelectedIndices().length + " out of " + this.numberOfItems + " values");
        } else {
            this.selectionLabel.setText("");
        }
    }
}

