/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.compound.MoleculeUtil;
import org.broadinstitute.genee.filter.AbstractDatasetFilter;
import org.broadinstitute.genee.filter.AbstractFilter;
import org.broadinstitute.genee.filter.AbstractFloatFilter;
import org.broadinstitute.genee.filter.ComparisonFilterComponent;
import org.broadinstitute.genee.filter.Filter;
import org.broadinstitute.genee.filter.FilterComponent;
import org.broadinstitute.genee.filter.FilterComponentCreator;
import org.broadinstitute.genee.filter.GT;
import org.broadinstitute.genee.filter.LT;
import org.broadinstitute.genee.filter.StructuralFilterComponent;
import org.broadinstitute.genee.filter.TextFilterComponent;
import org.broadinstitute.genee.filter.TopFilterComponent;
import org.broadinstitute.genee.heatmap.LuceneSearchParser;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.matrix.AbstractVector;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.stats.Sorting;

public class Filters {
    public static FilterComponent createFilterComponent(Filter filter) {
        if (filter instanceof TextFilter) {
            return new TextFilterComponent((TextFilter)filter);
        }
        if (filter instanceof TopFilter) {
            return new TopFilterComponent((TopFilter)filter);
        }
        if (filter instanceof FunctionFilter) {
            return new ComparisonFilterComponent((FunctionFilter)filter);
        }
        if (filter instanceof RowMetadataNumberFilter) {
            return new ComparisonFilterComponent((RowMetadataNumberFilter)filter);
        }
        if (filter instanceof StructuralFilter) {
            return new StructuralFilterComponent((StructuralFilter)filter);
        }
        return null;
    }

    public static List<FilterComponentCreator> createNumberMetadataFilters() {
        Project project = Application.getProject();
        ArrayList<FilterComponentCreator> list = new ArrayList<FilterComponentCreator>();
        if (project != null) {
            List<String> columns = MetadataUtil.getColumnNames(project.getOriginalDataset().getRowMetadata(), Number.class);
            for (final String name : columns) {
                FilterComponentCreator c = new FilterComponentCreator(){

                    @Override
                    public FilterComponent createFilterComponent() {
                        return new ComparisonFilterComponent(new RowMetadataNumberFilter(name));
                    }

                    public String toString() {
                        return name;
                    }
                };
                list.add(c);
            }
        }
        return list;
    }

    public static FilterComponentCreator createStructuralFilterComponent(final String metadataColumnName) {
        return new FilterComponentCreator(){

            @Override
            public FilterComponent createFilterComponent() {
                return new StructuralFilterComponent(new StructuralFilter(metadataColumnName));
            }

            public String toString() {
                return "Tanimoto";
            }
        };
    }

    public static FilterComponentCreator createTextFilterComponent() {
        return new FilterComponentCreator(){

            @Override
            public FilterComponent createFilterComponent() {
                return new TextFilterComponent(new TextFilter());
            }

            public String toString() {
                return "Text";
            }
        };
    }

    public static FilterComponentCreator createTopFilterComponent() {
        return new FilterComponentCreator(){

            @Override
            public FilterComponent createFilterComponent() {
                return new TopFilterComponent(new TopFilter());
            }

            public String toString() {
                return "Top Or Bottom";
            }
        };
    }

    public static class TopFilter
    extends AbstractFilter {
        private AbstractFloatFilter greaterOrLessThanFilter = new GT();
        private boolean top = true;
        private int n = -1;
        private DatasetRowView rowView = new DatasetRowView(null);
        private FloatListFunction function;
        private String metadataName;
        private Vector vector;

        @Override
        public boolean accept(int index) {
            Number n = (Number)this.vector.getValue(index);
            return n == null ? false : this.greaterOrLessThanFilter.apply(n.floatValue());
        }

        public FloatListFunction getFunction() {
            return this.function;
        }

        public String getMetadataName() {
            return this.metadataName;
        }

        public int getN() {
            return this.n;
        }

        @Override
        public void init(Object object) {
            if (this.n > 0) {
                Dataset dataset = (Dataset)object;
                this.vector = this.createVector(dataset);
                ArrayList<Sorting.FloatIntPair> pairs = new ArrayList<Sorting.FloatIntPair>();
                int rows = dataset.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    float val;
                    Number n = (Number)this.vector.getValue(i);
                    if (n == null || Float.isNaN(val = n.floatValue()) || Float.isInfinite(val)) continue;
                    pairs.add(new Sorting.FloatIntPair(val, i));
                }
                int n = this.n;
                int[] sortedIndices = Sorting.index(pairs.toArray(new Sorting.FloatIntPair[0]), !this.top);
                if (n >= sortedIndices.length) {
                    n = sortedIndices.length - 1;
                } else if (n < 0) {
                    n = 0;
                }
                float value = ((Number)this.vector.getValue(sortedIndices[n])).floatValue();
                if (this.top) {
                    this.greaterOrLessThanFilter = new GT();
                    this.greaterOrLessThanFilter.setValue(value);
                } else {
                    this.greaterOrLessThanFilter = new LT();
                    this.greaterOrLessThanFilter.setValue(value);
                }
            } else {
                this.greaterOrLessThanFilter.setValue(Float.NaN);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.metadataName == null && this.function == null || this.n <= 0;
        }

        public boolean isTop() {
            return this.top;
        }

        public void setFilterBy(Object object) {
            this.function = null;
            this.metadataName = null;
            if (object instanceof FloatListFunction) {
                this.function = (FloatListFunction)object;
            } else if (object instanceof String) {
                this.metadataName = (String)object;
            }
            this.fireFilterChanged();
        }

        public void setN(int val) {
            this.n = val;
            this.fireFilterChanged();
        }

        public void setTop(boolean top) {
            this.top = top;
            this.fireFilterChanged();
        }

        public String toString() {
            return "Top";
        }

        protected Vector createVector(final Dataset dataset) {
            if (this.metadataName != null) {
                return dataset.getRowMetadata().get(dataset.getRowMetadata().getColumnIndex(this.metadataName));
            }
            this.rowView.setDataset(dataset);
            return new AbstractVector(this.function.toString(), Number.class){

                @Override
                public Object getValue(int index) {
                    TopFilter.this.rowView.setIndex(index);
                    return Float.valueOf(TopFilter.this.function.evaluate(TopFilter.this.rowView));
                }

                @Override
                public void setValue(int index, Object value) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int size() {
                    return dataset.getRowCount();
                }
            };
        }
    }

    public static class TextFilter
    extends AbstractFilter {
        private boolean caseSensitive = false;
        protected String metadataColumnName;
        private String originalSearchText;
        private int matchMode = 0;
        private LuceneSearchParser.IndexedSearchPredicate predicate;

        @Override
        public boolean accept(int rowIndex) {
            return this.predicate.accept(rowIndex);
        }

        @Override
        public void init(Object object) {
            this.predicate.setData(object);
        }

        @Override
        public boolean isEmpty() {
            return this.predicate == null;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            this.createPredicate();
        }

        public void setMatchMode(int mode) {
            this.matchMode = mode;
            this.createPredicate();
        }

        public void setMetadataColumnName(String column) {
            this.metadataColumnName = column;
            this.createPredicate();
        }

        public void setText(String text) {
            this.originalSearchText = text;
            this.createPredicate();
        }

        public String toString() {
            return "Text";
        }

        private void createPredicate() {
            if (this.originalSearchText != null) {
                LuceneSearchParser.SearchPredicateAdapterCreator creator = new LuceneSearchParser.SearchPredicateAdapterCreator(){

                    @Override
                    public LuceneSearchParser.IndexedSearchPredicate create(LuceneSearchParser.InternalSearchPredicate internalSearchPredicate) {
                        return new LuceneSearchParser.DatasetSearchPredicateAdapter(internalSearchPredicate);
                    }
                };
                this.predicate = LuceneSearchParser.parse(creator, this.originalSearchText, this.caseSensitive, true, this.matchMode, this.metadataColumnName);
            } else {
                this.predicate = null;
            }
            this.fireFilterChanged();
        }
    }

    public static class StructuralFilter
    extends AbstractDatasetFilter {
        private String column;
        private AbstractFloatFilter floatFilter = new LT();
        private Molecule molecule;

        public StructuralFilter(String column) {
            this.floatFilter.setValue(Float.NaN);
            this.column = column;
        }

        @Override
        public boolean accept(int rowIndex) {
            Molecule m = (Molecule)this.dataset.getRowMetadata().getValue(rowIndex, this.column);
            if (m == null) {
                return false;
            }
            float dist = MoleculeUtil.getTanimoto(this.molecule, m);
            return this.floatFilter.apply(dist);
        }

        @Override
        public boolean isEmpty() {
            return this.molecule == null || Float.isNaN(this.floatFilter.value);
        }

        public void setFloatFilter(AbstractFloatFilter floatFilter) {
            float oldValue = floatFilter.value;
            this.floatFilter = floatFilter;
            this.floatFilter.setValue(oldValue);
            this.fireFilterChanged();
        }

        public void setSmileString(String text) {
            this.molecule = MoleculeUtil.read(text);
            this.fireFilterChanged();
        }

        public void setValue(float d) {
            this.floatFilter.setValue(d);
            this.fireFilterChanged();
        }

        public String toString() {
            return "Tanimoto";
        }
    }

    public static class RowMetadataNumberFilter
    extends FloatFilterAdapter {
        private String metadataColumnName;

        public RowMetadataNumberFilter(String metadataColumnName) {
            this.metadataColumnName = metadataColumnName;
        }

        @Override
        public boolean accept(int rowIndex) {
            Number number = (Number)this.dataset.getRowMetadata().getValue(rowIndex, this.metadataColumnName);
            if (number == null) {
                return false;
            }
            return this.floatFilter.apply(number.floatValue());
        }

        @Override
        public boolean isEmpty() {
            return this.floatFilter == null || Float.isNaN(this.floatFilter.value);
        }

        public String toString() {
            return this.metadataColumnName;
        }
    }

    public static class FunctionFilter
    extends FloatFilterAdapter {
        protected DatasetRowView rowView = new DatasetRowView(null);
        private FloatListFunction function;

        public FunctionFilter(FloatListFunction function) {
            this.function = function;
        }

        @Override
        public boolean accept(int rowIndex) {
            this.rowView.setDataset(this.dataset);
            this.rowView.setIndex(rowIndex);
            return this.floatFilter.apply(this.function.evaluate(this.rowView));
        }

        @Override
        public boolean isEmpty() {
            return this.floatFilter == null || Float.isNaN(this.floatFilter.value);
        }

        public String toString() {
            return this.function.toString();
        }
    }

    public static abstract class FloatFilterAdapter
    extends AbstractDatasetFilter {
        protected AbstractFloatFilter floatFilter = new GT();

        public AbstractFloatFilter getFloatFilter() {
            return this.floatFilter;
        }

        public void setFloatFilter(AbstractFloatFilter floatFilter) {
            AbstractFloatFilter oldFilter = this.floatFilter;
            this.floatFilter = floatFilter;
            if (oldFilter != null) {
                this.floatFilter.setValue(oldFilter.value);
            }
            this.fireFilterChanged();
        }

        public void setValue(float d) {
            this.floatFilter.setValue(d);
            this.fireFilterChanged();
        }
    }
}

