/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import org.broadinstitute.genee.filter.IndexedFilter;
import org.broadinstitute.genee.matrix.Vector;

public class RangeIndexedFilter
implements IndexedFilter {
    private Vector filterValueProvider;
    private float min;
    private float max;

    public RangeIndexedFilter(float min, float max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean accept(int index) {
        Number val = (Number)this.filterValueProvider.getValue(index);
        if (val == null) {
            return false;
        }
        float _val = val.floatValue();
        return _val >= this.min && _val <= this.max;
    }

    @Override
    public void setValueProvider(Vector filterValueProvider) {
        this.filterValueProvider = filterValueProvider;
    }
}

